"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetDataOnScreenFunction = registerGetDataOnScreenFunction;
var _lodash = require("lodash");
var _dedent = _interopRequireDefault(require("dedent"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGetDataOnScreenFunction(functions, screenContexts) {
  const allData = (0, _lodash.compact)(screenContexts.flatMap(context => context.data));
  if (!allData.length) {
    return;
  }
  functions.registerFunction({
    name: _common.GET_DATA_ON_SCREEN_FUNCTION_NAME,
    description: `Retrieve the structured data of content currently visible on the user's screen. Use this tool to understand what the user is viewing at this moment to provide more accurate and context-aware responses to their questions.`,
    parameters: {
      type: 'object',
      properties: {
        data: {
          type: 'array',
          description: 'The pieces of data you want to look at it. You can request one, or multiple',
          items: {
            type: 'string',
            enum: allData.map(data => data.name)
          }
        }
      },
      required: ['data']
    }
  }, async ({
    arguments: {
      data: dataNames
    }
  }) => {
    return {
      content: allData.filter(data => dataNames.includes(data.name))
    };
  });
  functions.registerInstruction(({
    availableFunctionNames
  }) => {
    if (availableFunctionNames.includes(_common.GET_DATA_ON_SCREEN_FUNCTION_NAME)) {
      return `You have access to data on the screen by calling the "${_common.GET_DATA_ON_SCREEN_FUNCTION_NAME}" tool.
        Use it to help the user understand what they are looking at. 
        
        This tool will retrieve specific content from the user's screen by specifying a data key. Use this tool to provide context-aware responses. Available data: ${(0, _dedent.default)(allData.map(data => `${data.name}: ${data.description}`).join('\n'))}

        A short summary of what they are looking at is available in the return of the "${_common.CONTEXT_FUNCTION_NAME}" function.
        Data that is compact enough automatically gets included in the response for the "${_common.CONTEXT_FUNCTION_NAME}" function.`;
    }
    return undefined;
  });
}