"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatService = createChatService;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _conversation_complete = require("../../common/conversation_complete");
var _filter_function_definitions = require("../../common/utils/filter_function_definitions");
var _throw_serialized_chat_completion_errors = require("../../common/utils/throw_serialized_chat_completion_errors");
var _until_aborted = require("../../common/utils/until_aborted");
var _analytics = require("../analytics");
var _readable_stream_reader_into_observable = require("../utils/readable_stream_reader_into_observable");
var _complete = require("./complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_DELAY = 10;
function toObservable(response) {
  var _response$response, _response$response$bo;
  const status = (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.status;
  if (!status || status >= 400) {
    var _response$response2;
    throw new Error(((_response$response2 = response.response) === null || _response$response2 === void 0 ? void 0 : _response$response2.statusText) || 'Unexpected error');
  }
  const reader = (_response$response$bo = response.response.body) === null || _response$response$bo === void 0 ? void 0 : _response$response$bo.getReader();
  if (!reader) {
    throw new Error('Could not get reader from response');
  }
  return (0, _readable_stream_reader_into_observable.readableStreamReaderIntoObservable)(reader).pipe(
  // append a timestamp of when each value was emitted
  (0, _rxjs.timestamp)(),
  // use the previous timestamp to calculate a target
  // timestamp for emitting the next value
  (0, _rxjs.scan)((acc, value) => {
    const lastTimestamp = acc.timestamp || 0;
    const emitAt = Math.max(lastTimestamp + MIN_DELAY, value.timestamp);
    return {
      timestamp: emitAt,
      value: value.value
    };
  }),
  // add the delay based on the elapsed time
  // using concatMap(of(value).pipe(delay(50))
  // leads to browser issues because timers
  // are throttled when the tab is not active
  (0, _rxjs.concatMap)(value => {
    const now = Date.now();
    const delayFor = value.timestamp - now;
    if (delayFor <= 0) {
      return (0, _rxjs.of)(value.value);
    }
    return (0, _rxjs.of)(value.value).pipe((0, _rxjs.delay)(delayFor));
  }));
}
function serialize(signal) {
  return source$ => source$.pipe((0, _rxjs.catchError)(error => {
    if ('response' in error && 'json' in error.response && typeof error.response.json === 'function') {
      const responseBodyPromise = error.response.json();
      return (0, _rxjs.from)(responseBodyPromise.then(body => {
        if (body) {
          error.body = body;
          if (body.message) {
            error.message = body.message;
          }
        }
        throw error;
      }));
    }
    return (0, _rxjs.throwError)(() => error);
  }), (0, _rxjs.switchMap)(readable => toObservable(readable)), (0, _rxjs.map)(line => JSON.parse(line)), (0, _rxjs.filter)(line => line.type !== _conversation_complete.StreamingChatResponseEventType.BufferFlush), (0, _throw_serialized_chat_completion_errors.throwSerializedChatCompletionErrors)(), (0, _until_aborted.untilAborted)(signal), (0, _rxjs.shareReplay)());
}
class ChatService {
  constructor({
    abortSignal,
    apiClient,
    scope$,
    analytics,
    registrations
  }) {
    (0, _defineProperty2.default)(this, "functionRegistry", void 0);
    (0, _defineProperty2.default)(this, "renderFunctionRegistry", void 0);
    (0, _defineProperty2.default)(this, "abortSignal", void 0);
    (0, _defineProperty2.default)(this, "apiClient", void 0);
    (0, _defineProperty2.default)(this, "scope$", void 0);
    (0, _defineProperty2.default)(this, "analytics", void 0);
    (0, _defineProperty2.default)(this, "registrations", void 0);
    (0, _defineProperty2.default)(this, "systemMessage", void 0);
    (0, _defineProperty2.default)(this, "functions$", void 0);
    (0, _defineProperty2.default)(this, "getClient", () => {
      return {
        chat: this.chat,
        complete: this.complete
      };
    });
    (0, _defineProperty2.default)(this, "sendAnalyticsEvent", event => {
      (0, _analytics.sendEvent)(this.analytics, event);
    });
    (0, _defineProperty2.default)(this, "renderFunction", (name, args, response, onActionClick) => {
      var _response$content, _response$data;
      const fn = this.renderFunctionRegistry.get(name);
      if (!fn) {
        throw new Error(`Function ${name} not found`);
      }
      const parsedArguments = args ? JSON.parse(args) : {};
      const parsedResponse = {
        content: JSON.parse((_response$content = response.content) !== null && _response$content !== void 0 ? _response$content : '{}'),
        data: JSON.parse((_response$data = response.data) !== null && _response$data !== void 0 ? _response$data : '{}')
      };
      return fn === null || fn === void 0 ? void 0 : fn({
        response: parsedResponse,
        arguments: parsedArguments,
        onActionClick
      });
    });
    (0, _defineProperty2.default)(this, "getFunctions", options => {
      return (0, _filter_function_definitions.filterFunctionDefinitions)({
        ...options,
        definitions: Array.from(this.functionRegistry.values())
      });
    });
    (0, _defineProperty2.default)(this, "hasFunction", name => {
      return this.functionRegistry.has(name);
    });
    (0, _defineProperty2.default)(this, "hasRenderFunction", name => {
      return this.renderFunctionRegistry.has(name);
    });
    (0, _defineProperty2.default)(this, "getSystemMessage", () => this.systemMessage);
    (0, _defineProperty2.default)(this, "chat", (name, {
      connectorId,
      systemMessage,
      messages,
      functionCall,
      functions,
      signal
    }) => {
      return this.callStreamingApi('POST /internal/observability_ai_assistant/chat', {
        params: {
          body: {
            name,
            systemMessage,
            messages,
            connectorId,
            functionCall,
            functions: functions !== null && functions !== void 0 ? functions : [],
            scopes: this.getScopes()
          }
        },
        signal
      }).pipe((0, _rxjs.filter)(line => line.type === _conversation_complete.StreamingChatResponseEventType.ChatCompletionChunk));
    });
    (0, _defineProperty2.default)(this, "complete", ({
      getScreenContexts,
      connectorId,
      conversationId,
      systemMessage,
      messages,
      persist,
      disableFunctions,
      signal,
      instructions
    }) => {
      return (0, _complete.complete)({
        getScreenContexts,
        connectorId,
        conversationId,
        systemMessage,
        messages,
        persist,
        disableFunctions,
        signal,
        client: this.getClient(),
        instructions,
        scopes: this.getScopes()
      }, ({
        params
      }) => {
        return this.callStreamingApi('POST /internal/observability_ai_assistant/chat/complete', {
          params,
          signal
        });
      });
    });
    this.functionRegistry = new Map();
    this.renderFunctionRegistry = new Map();
    this.abortSignal = abortSignal;
    this.apiClient = apiClient;
    this.scope$ = scope$;
    this.analytics = analytics;
    this.registrations = registrations;
    this.systemMessage = '';
    this.functions$ = new _rxjs.BehaviorSubject([]);
    scope$.subscribe(() => {
      this.initialize();
    });
  }
  async initialize() {
    this.functionRegistry = new Map();
    const scopePromise = this.apiClient('GET /internal/observability_ai_assistant/functions', {
      signal: this.abortSignal,
      params: {
        query: {
          scopes: this.getScopes()
        }
      }
    }).then(({
      functionDefinitions,
      systemMessage
    }) => {
      functionDefinitions.forEach(fn => this.functionRegistry.set(fn.name, fn));
      this.systemMessage = systemMessage;
    });
    await Promise.all([scopePromise, ...this.registrations.map(registration => {
      return registration({
        registerRenderFunction: (name, renderFn) => {
          this.renderFunctionRegistry.set(name, renderFn);
        }
      });
    })]);
    this.functions$.next(this.getFunctions());
  }
  callStreamingApi(endpoint, options) {
    return (0, _rxjs.from)(this.apiClient(endpoint, {
      ...options,
      asResponse: true,
      rawResponse: true
    })).pipe(serialize(options.signal));
  }
  getScopes() {
    return this.scope$.value;
  }
}
async function createChatService({
  analytics,
  signal: setupAbortSignal,
  registrations,
  apiClient,
  scope$
}) {
  return new ChatService({
    analytics,
    apiClient,
    scope$,
    registrations,
    abortSignal: setupAbortSignal
  });
}