"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingChatResponseEventType = exports.ChatCompletionErrorCode = exports.ChatCompletionError = void 0;
exports.createConversationNotFoundError = createConversationNotFoundError;
exports.createFunctionLimitExceededError = createFunctionLimitExceededError;
exports.createInternalServerError = createInternalServerError;
exports.createTokenLimitReachedError = createTokenLimitReachedError;
exports.isChatCompletionError = isChatCompletionError;
exports.isTokenLimitReachedError = isTokenLimitReachedError;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let StreamingChatResponseEventType = exports.StreamingChatResponseEventType = /*#__PURE__*/function (StreamingChatResponseEventType) {
  StreamingChatResponseEventType["ChatCompletionChunk"] = "chatCompletionChunk";
  StreamingChatResponseEventType["ChatCompletionMessage"] = "chatCompletionMessage";
  StreamingChatResponseEventType["ConversationCreate"] = "conversationCreate";
  StreamingChatResponseEventType["ConversationUpdate"] = "conversationUpdate";
  StreamingChatResponseEventType["MessageAdd"] = "messageAdd";
  StreamingChatResponseEventType["ChatCompletionError"] = "chatCompletionError";
  StreamingChatResponseEventType["BufferFlush"] = "bufferFlush";
  return StreamingChatResponseEventType;
}({});
let ChatCompletionErrorCode = exports.ChatCompletionErrorCode = /*#__PURE__*/function (ChatCompletionErrorCode) {
  ChatCompletionErrorCode["InternalError"] = "internalError";
  ChatCompletionErrorCode["NotFoundError"] = "notFoundError";
  ChatCompletionErrorCode["TokenLimitReachedError"] = "tokenLimitReachedError";
  ChatCompletionErrorCode["FunctionLimitExceededError"] = "functionLimitExceededError";
  return ChatCompletionErrorCode;
}({});
class ChatCompletionError extends Error {
  constructor(code, message, meta = {}) {
    super(message);
    this.code = code;
    this.meta = meta;
  }
}
exports.ChatCompletionError = ChatCompletionError;
function createTokenLimitReachedError(tokenLimit, tokenCount) {
  return new ChatCompletionError(ChatCompletionErrorCode.TokenLimitReachedError, _i18n.i18n.translate('xpack.observabilityAiAssistant.chatCompletionError.tokenLimitReachedError', {
    defaultMessage: `Token limit reached. Token limit is {tokenLimit}, but the current conversation has {tokenCount} tokens.`,
    values: {
      tokenLimit,
      tokenCount
    }
  }), {
    tokenLimit,
    tokenCount
  });
}
function createConversationNotFoundError() {
  return new ChatCompletionError(ChatCompletionErrorCode.NotFoundError, _i18n.i18n.translate('xpack.observabilityAiAssistant.chatCompletionError.conversationNotFoundError', {
    defaultMessage: 'Conversation not found'
  }));
}
function createInternalServerError(originalErrorMessage = _i18n.i18n.translate('xpack.observabilityAiAssistant.chatCompletionError.internalServerError', {
  defaultMessage: 'An internal server error occurred'
})) {
  return new ChatCompletionError(ChatCompletionErrorCode.InternalError, originalErrorMessage);
}
function createFunctionLimitExceededError() {
  return new ChatCompletionError(ChatCompletionErrorCode.FunctionLimitExceededError, `Function limit exceeded`);
}
function isTokenLimitReachedError(error) {
  return error instanceof ChatCompletionError && error.code === ChatCompletionErrorCode.TokenLimitReachedError;
}
function isChatCompletionError(error) {
  return error instanceof ChatCompletionError;
}