"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilityDataSources = getObservabilityDataSources;
var _get_logs_indices = require("./get_logs_indices");
var _get_metrics_indices = require("./get_metrics_indices");
var _get_apm_indices = require("./get_apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getObservabilityDataSources({
  core,
  plugins,
  logger
}) {
  const apmIndexPatterns = await (0, _get_apm_indices.getApmIndices)({
    core,
    plugins,
    logger
  });
  const logIndexPatterns = await (0, _get_logs_indices.getLogsIndices)({
    core,
    logger
  });
  const metricIndexPatterns = await (0, _get_metrics_indices.getMetricsIndices)({
    core,
    plugins,
    logger
  });
  const alertsIndexPattern = ['alerts-observability-*'];
  return {
    apmIndexPatterns,
    logIndexPatterns,
    metricIndexPatterns,
    alertsIndexPattern
  };
}