"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultConnectorId = getDefaultConnectorId;
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_DEFAULT_CONNECTOR = 'NO_DEFAULT_CONNECTOR';

/**
 * Gets the default connector ID by first checking the UI settings (genAI settings),
 * then falling back to the inference plugin's default connector.
 */
async function getDefaultConnectorId({
  coreStart,
  inference,
  request,
  logger
}) {
  var _await$inference$getD;
  const soClient = coreStart.savedObjects.getScopedClient(request);
  const uiSettingsClient = coreStart.uiSettings.asScopedToClient(soClient);
  const defaultConnectorSetting = await uiSettingsClient.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR);
  const hasValidDefaultConnector = defaultConnectorSetting && defaultConnectorSetting !== NO_DEFAULT_CONNECTOR;
  if (hasValidDefaultConnector) {
    logger === null || logger === void 0 ? void 0 : logger.debug(`Using default AI connector from UI setting: ${defaultConnectorSetting}`);
    return defaultConnectorSetting;
  }
  const connectorId = (_await$inference$getD = await inference.getDefaultConnector(request)) === null || _await$inference$getD === void 0 ? void 0 : _await$inference$getD.connectorId;
  if (!connectorId) {
    throw new Error('No AI connector configured.');
  }
  logger === null || logger === void 0 ? void 0 : logger.debug(`Using default connector from inference plugin: ${connectorId}`);
  return connectorId;
}