"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getToolHandler({
  request,
  dataRegistry,
  start,
  end,
  environment,
  healthStatus
}) {
  var _response$items, _response$maxCountExc, _response$serviceOver;
  const response = await dataRegistry.getData('servicesItems', {
    request,
    environment,
    start,
    end
  });
  const services = ((_response$items = response === null || response === void 0 ? void 0 : response.items) !== null && _response$items !== void 0 ? _response$items : []).filter(item => {
    var _item$healthStatus;
    if (!healthStatus) {
      return true;
    }
    return healthStatus.includes((_item$healthStatus = item.healthStatus) !== null && _item$healthStatus !== void 0 ? _item$healthStatus : 'unknown');
  });
  return {
    services,
    maxCountExceeded: (_response$maxCountExc = response === null || response === void 0 ? void 0 : response.maxCountExceeded) !== null && _response$maxCountExc !== void 0 ? _response$maxCountExc : false,
    serviceOverflowCount: (_response$serviceOver = response === null || response === void 0 ? void 0 : response.serviceOverflowCount) !== null && _response$serviceOver !== void 0 ? _response$serviceOver : 0
  };
}