"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
var _time = require("../../utils/time");
var _dsl_filters = require("../../utils/dsl_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getToolHandler({
  request,
  dataRegistry,
  start,
  end,
  limit,
  kqlFilter: kqlFilterValue
}) {
  const startMs = (0, _time.parseDatemath)(start);
  const endMs = (0, _time.parseDatemath)(end, {
    roundUp: true
  });
  if (!startMs || !endMs) {
    throw new Error('Invalid date range provided.');
  }
  const query = kqlFilterValue ? {
    bool: {
      filter: (0, _dsl_filters.kqlFilter)(kqlFilterValue)
    }
  } : undefined;
  const result = await dataRegistry.getData('infraHosts', {
    request,
    from: new Date(startMs).toISOString(),
    to: new Date(endMs).toISOString(),
    limit,
    query
  });
  if (!result) {
    throw new Error('Host data is not available.');
  }
  return {
    hosts: result.nodes,
    total: result.nodes.length
  };
}