"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
var _get_observability_data_sources = require("../../utils/get_observability_data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getToolHandler({
  core,
  plugins,
  logger
}) {
  const {
    apmIndexPatterns: apmIndices,
    logIndexPatterns,
    metricIndexPatterns,
    alertsIndexPattern
  } = await (0, _get_observability_data_sources.getObservabilityDataSources)({
    core,
    plugins,
    logger
  });
  return {
    apm: {
      indexPatterns: apmIndices
    },
    logs: {
      indexPatterns: logIndexPatterns
    },
    metrics: {
      indexPatterns: metricIndexPatterns
    },
    alerts: {
      indexPattern: alertsIndexPattern
    }
  };
}