"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
var _lodash = require("lodash");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _common = require("@kbn/observability-shared-plugin/common");
var _get_relevant_alert_fields = require("./get_relevant_alert_fields");
var _get_hits_total = require("../../utils/get_hits_total");
var _dsl_filters = require("../../utils/dsl_filters");
var _get_default_connector_id = require("../../utils/get_default_connector_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OMITTED_ALERT_FIELDS = ['event.action', 'event.kind', 'kibana.alert.rule.execution.uuid', 'kibana.alert.rule.revision', 'kibana.alert.rule.tags', 'kibana.alert.rule.uuid', 'kibana.alert.workflow_status', 'kibana.space_ids', 'kibana.alert.time_range', 'kibana.version'];
async function getToolHandler({
  core,
  request,
  logger,
  start,
  end,
  query,
  kqlFilter,
  includeRecovered
}) {
  const [coreStart, pluginStart] = await core.getStartServices();
  const {
    inference,
    ruleRegistry
  } = pluginStart;
  const alertsClient = await ruleRegistry.getRacClientWithRequest(request);
  const connectorId = await (0, _get_default_connector_id.getDefaultConnectorId)({
    coreStart,
    inference,
    request,
    logger
  });
  const boundInferenceClient = inference.getClient({
    request,
    bindTo: {
      connectorId
    }
  });
  const selectedFields = await (0, _get_relevant_alert_fields.getRelevantAlertFields)({
    coreStart,
    pluginStart,
    request,
    inferenceClient: boundInferenceClient,
    logger,
    query
  });
  const response = await alertsClient.find({
    ruleTypeIds: _common.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: [_technical_rule_data_field_names.AlertConsumers.APM, _technical_rule_data_field_names.AlertConsumers.INFRASTRUCTURE, _technical_rule_data_field_names.AlertConsumers.LOGS, _technical_rule_data_field_names.AlertConsumers.UPTIME, _technical_rule_data_field_names.AlertConsumers.SLO, _technical_rule_data_field_names.AlertConsumers.OBSERVABILITY, _technical_rule_data_field_names.AlertConsumers.ALERTS],
    query: {
      bool: {
        filter: [{
          range: {
            'kibana.alert.start': {
              gte: start,
              lte: end
            }
          }
        }, ...(0, _dsl_filters.kqlFilter)(kqlFilter), ...(includeRecovered ? [] : [{
          term: {
            [_technical_rule_data_field_names.ALERT_STATUS]: _technical_rule_data_field_names.ALERT_STATUS_ACTIVE
          }
        }])]
      }
    },
    size: 10
  });
  const total = (0, _get_hits_total.getHitsTotal)(response);
  const alerts = response.hits.hits.map(hit => {
    var _hit$_source;
    return (0, _lodash.omit)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {}, ...OMITTED_ALERT_FIELDS);
  });
  return {
    alerts,
    selectedFields,
    total
  };
}