"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilityAgentBuilderAiInsightsRouteRepository = getObservabilityAgentBuilderAiInsightsRouteRepository;
var t = _interopRequireWildcard(require("io-ts"));
var _features = require("@kbn/onechat-plugin/common/features");
var _generate_error_ai_insight = require("./apm_error/generate_error_ai_insight");
var _create_observability_agent_builder_server_route = require("../create_observability_agent_builder_server_route");
var _get_log_ai_insights = require("./get_log_ai_insights");
var _get_alert_ai_insights = require("./get_alert_ai_insights");
var _get_default_connector_id = require("../../utils/get_default_connector_id");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getObservabilityAgentBuilderAiInsightsRouteRepository() {
  const getAlertAiInsightRoute = (0, _create_observability_agent_builder_server_route.createObservabilityAgentBuilderServerRoute)({
    endpoint: 'POST /internal/observability_agent_builder/ai_insights/alert',
    options: {
      access: 'internal'
    },
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    params: t.type({
      body: t.type({
        alertId: t.string
      })
    }),
    handler: async ({
      core,
      dataRegistry,
      logger,
      request,
      params
    }) => {
      const {
        alertId
      } = params.body;
      const [coreStart, startDeps] = await core.getStartServices();
      const {
        inference,
        ruleRegistry
      } = startDeps;
      const connectorId = await (0, _get_default_connector_id.getDefaultConnectorId)({
        coreStart,
        inference,
        request,
        logger
      });
      const inferenceClient = inference.getClient({
        request
      });
      const alertsClient = await ruleRegistry.getRacClientWithRequest(request);
      const alertDoc = await alertsClient.get({
        id: alertId
      });
      const {
        summary,
        context
      } = await (0, _get_alert_ai_insights.getAlertAiInsight)({
        alertDoc,
        inferenceClient,
        connectorId,
        dataRegistry,
        request,
        logger
      });
      return {
        summary,
        context
      };
    }
  });
  const errorAiInsightsRoute = (0, _create_observability_agent_builder_server_route.createObservabilityAgentBuilderServerRoute)({
    endpoint: 'POST /internal/observability_agent_builder/ai_insights/error',
    options: {
      access: 'internal'
    },
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    params: t.type({
      body: t.type({
        errorId: t.string,
        start: t.string,
        end: t.string,
        serviceName: t.string,
        environment: t.union([t.string, t.undefined])
      })
    }),
    handler: async ({
      request,
      core,
      plugins,
      dataRegistry,
      params,
      logger
    }) => {
      const {
        errorId,
        serviceName,
        start,
        end,
        environment = ''
      } = params.body;
      const [coreStart, startDeps] = await core.getStartServices();
      const {
        inference
      } = startDeps;
      const connectorId = await (0, _get_default_connector_id.getDefaultConnectorId)({
        coreStart,
        inference,
        request,
        logger
      });
      const inferenceClient = inference.getClient({
        request,
        bindTo: {
          connectorId
        }
      });
      const {
        summary,
        context
      } = await (0, _generate_error_ai_insight.generateErrorAiInsight)({
        core,
        plugins,
        errorId,
        serviceName,
        start,
        end,
        environment,
        dataRegistry,
        request,
        inferenceClient,
        logger
      });
      return {
        context,
        summary
      };
    }
  });
  const logAiInsightsRoute = (0, _create_observability_agent_builder_server_route.createObservabilityAgentBuilderServerRoute)({
    endpoint: 'POST /internal/observability_agent_builder/ai_insights/log',
    options: {
      access: 'internal'
    },
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    params: t.type({
      body: t.type({
        index: t.string,
        id: t.string
      })
    }),
    handler: async ({
      request,
      core,
      dataRegistry,
      params
    }) => {
      const {
        index,
        id
      } = params.body;
      const [coreStart, startDeps] = await core.getStartServices();
      const {
        inference
      } = startDeps;
      const connectorId = await (0, _get_default_connector_id.getDefaultConnectorId)({
        coreStart,
        inference,
        request
      });
      const inferenceClient = inference.getClient({
        request
      });
      const esClient = coreStart.elasticsearch.client.asScoped(request);
      const {
        summary,
        context
      } = await (0, _get_log_ai_insights.getLogAiInsights)({
        index,
        id,
        inferenceClient,
        connectorId,
        request,
        esClient,
        dataRegistry
      });
      return {
        summary,
        context
      };
    }
  });
  return {
    ...logAiInsightsRoute,
    ...errorAiInsightsRoute,
    ...getAlertAiInsightRoute
  };
}