"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAgentBuilderPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_observability_agent = require("./agent/register_observability_agent");
var _register_tools = require("./tools/register_tools");
var _register_attachments = require("./attachments/register_attachments");
var _data_registry = require("./data_registry/data_registry");
var _register_routes = require("./routes/register_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAgentBuilderPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "dataRegistry", void 0);
    this.logger = initContext.logger.get();
    this.dataRegistry = new _data_registry.ObservabilityAgentBuilderDataRegistry(this.logger);
  }
  setup(core, plugins) {
    (0, _register_observability_agent.registerObservabilityAgent)({
      core,
      plugins,
      logger: this.logger
    }).catch(error => {
      this.logger.error(`Error registering observability agent: ${error}`);
    });
    (0, _register_tools.registerTools)({
      core,
      plugins,
      dataRegistry: this.dataRegistry,
      logger: this.logger
    }).catch(error => {
      this.logger.error(`Error registering observability tools: ${error}`);
    });
    (0, _register_attachments.registerAttachments)({
      core,
      plugins,
      logger: this.logger,
      dataRegistry: this.dataRegistry
    }).catch(error => {
      this.logger.error(`Error registering observability attachments: ${error}`);
    });
    (0, _register_routes.registerServerRoutes)({
      core,
      plugins,
      logger: this.logger,
      dataRegistry: this.dataRegistry
    });
    return {
      registerDataProvider: (id, provider) => this.dataRegistry.registerDataProvider(id, provider)
    };
  }
  start(_core, _plugins) {
    return {};
  }
  stop() {}
}
exports.ObservabilityAgentBuilderPlugin = ObservabilityAgentBuilderPlugin;