"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAiInsight = LogAiInsight;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _use_kibana = require("../../hooks/use_kibana");
var _common = require("../../../common");
var _ai_insight = require("../ai_insight");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_agent_builder/public/components/insights/log_ai_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const explainLogMessageButtonLabel = _i18n.i18n.translate('xpack.observabilityAgentBuilder.logAiInsight.titleLabel', {
  defaultMessage: 'Explain this log entry'
});
function LogAiInsight({
  doc
}) {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const apiClient = (0, _serverRouteRepositoryClient.createRepositoryClient)({
    http
  });
  const {
    index,
    id
  } = (0, _react.useMemo)(() => {
    var _doc$fields$find, _doc$fields$find2;
    return {
      index: doc === null || doc === void 0 ? void 0 : (_doc$fields$find = doc.fields.find(field => field.field === '_index')) === null || _doc$fields$find === void 0 ? void 0 : _doc$fields$find.value[0],
      id: doc === null || doc === void 0 ? void 0 : (_doc$fields$find2 = doc.fields.find(field => field.field === '_id')) === null || _doc$fields$find2 === void 0 ? void 0 : _doc$fields$find2.value[0]
    };
  }, [doc]);
  if (typeof index !== 'string' || typeof id !== 'string') {
    return null;
  }
  const fetchInsight = async () => {
    const response = await apiClient.fetch('POST /internal/observability_agent_builder/ai_insights/log', {
      signal: null,
      params: {
        body: {
          index,
          id
        }
      }
    });
    return response;
  };
  const buildAttachments = (summary, context) => [{
    type: 'screen_context',
    data: {
      app: 'discover',
      url: window.location.href
    },
    hidden: true
  }, {
    type: _common.OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID,
    data: {
      summary,
      context,
      attachmentLabel: _i18n.i18n.translate('xpack.observabilityAgentBuilder.logAiInsight.attachmentLabel', {
        defaultMessage: 'Log summary'
      })
    }
  }, {
    type: _common.OBSERVABILITY_LOG_ATTACHMENT_TYPE_ID,
    data: {
      index,
      id
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ai_insight.AiInsight, {
    title: explainLogMessageButtonLabel,
    fetchInsight: fetchInsight,
    buildAttachments: buildAttachments,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }));
}