"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorSampleAiInsight = ErrorSampleAiInsight;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _ai_insight = require("../ai_insight");
var _common = require("../../../common");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_agent_builder/public/components/insights/error_sample_ai_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorSampleAiInsight({
  errorId,
  serviceName,
  start,
  end,
  environment
}) {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const apiClient = (0, _serverRouteRepositoryClient.createRepositoryClient)({
    http
  });
  const fetchInsight = async () => {
    var _response$summary, _response$context;
    const response = await apiClient.fetch('POST /internal/observability_agent_builder/ai_insights/error', {
      signal: null,
      params: {
        body: {
          errorId,
          serviceName,
          start,
          end,
          environment
        }
      }
    });
    return {
      summary: (_response$summary = response.summary) !== null && _response$summary !== void 0 ? _response$summary : '',
      context: (_response$context = response.context) !== null && _response$context !== void 0 ? _response$context : ''
    };
  };
  const buildAttachments = (summary, context) => [{
    type: 'screen_context',
    data: {
      app: 'apm',
      url: window.location.href,
      description: `APM error details page for error ID ${errorId} on service ${serviceName}`
    },
    hidden: true
  }, {
    type: _common.OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID,
    data: {
      summary,
      context,
      attachmentLabel: _i18n.i18n.translate('xpack.observabilityAgentBuilder.errorAiInsight.attachmentLabel', {
        defaultMessage: 'Error summary'
      })
    }
  }, {
    type: _common.OBSERVABILITY_ERROR_ATTACHMENT_TYPE_ID,
    data: {
      errorId,
      serviceName,
      environment,
      start,
      end
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_ai_insight.AiInsight, {
    title: _i18n.i18n.translate('xpack.observabilityAgentBuilder.errorAiInsight.titleLabel', {
      defaultMessage: "What's this error?"
    }),
    fetchInsight: fetchInsight,
    buildAttachments: buildAttachments,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  });
}