"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAttachmentUiDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACHMENT_TYPE_CONFIGS = [{
  type: _constants.OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID,
  label: _i18n.i18n.translate('xpack.observabilityAgentBuilder.attachments.aiInsight.label', {
    defaultMessage: 'Summary'
  }),
  icon: 'sparkles'
}, {
  type: _constants.OBSERVABILITY_ALERT_ATTACHMENT_TYPE_ID,
  label: _i18n.i18n.translate('xpack.observabilityAgentBuilder.attachments.alert.label', {
    defaultMessage: 'Observability alert'
  }),
  icon: 'warning'
}, {
  type: _constants.OBSERVABILITY_ERROR_ATTACHMENT_TYPE_ID,
  label: _i18n.i18n.translate('xpack.observabilityAgentBuilder.attachments.error.label', {
    defaultMessage: 'APM error'
  }),
  icon: 'bug'
}, {
  type: _constants.OBSERVABILITY_LOG_ATTACHMENT_TYPE_ID,
  label: _i18n.i18n.translate('xpack.observabilityAgentBuilder.attachments.log.label', {
    defaultMessage: 'Log entry'
  }),
  icon: 'logPatternAnalysis'
}];
const createAttachmentTypeConfig = (defaultLabel, icon) => ({
  getLabel: attachment => {
    var _attachment$data;
    const attachmentLabel = attachment === null || attachment === void 0 ? void 0 : (_attachment$data = attachment.data) === null || _attachment$data === void 0 ? void 0 : _attachment$data.attachmentLabel;
    return attachmentLabel !== null && attachmentLabel !== void 0 ? attachmentLabel : defaultLabel;
  },
  getIcon: () => icon
});
const registerAttachmentUiDefinitions = ({
  attachments
}) => {
  ATTACHMENT_TYPE_CONFIGS.forEach(({
    type,
    label,
    icon
  }) => {
    attachments.addAttachmentType(type, createAttachmentTypeConfig(label, icon));
  });
};
exports.registerAttachmentUiDefinitions = registerAttachmentUiDefinitions;