"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsEmailService = void 0;
var _create_execute_function = require("@kbn/actions-plugin/server/create_execute_function");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConnectorsEmailService {
  constructor(requesterId, connectorId, actionsClient, logger) {
    this.requesterId = requesterId;
    this.connectorId = connectorId;
    this.actionsClient = actionsClient;
    this.logger = logger;
  }
  async sendPlainTextEmail(params) {
    const actions = params.to.map(to => {
      var _params$context;
      return {
        id: this.connectorId,
        params: {
          to: [to],
          subject: params.subject,
          message: params.message
        },
        relatedSavedObjects: (_params$context = params.context) === null || _params$context === void 0 ? void 0 : _params$context.relatedObjects
      };
    });
    const response = await this.actionsClient.bulkEnqueueExecution(this.requesterId, actions);
    if (response.errors) {
      this.logEnqueueExecutionResponse(response.items);
    }
  }
  async sendHTMLEmail(params) {
    const actions = params.to.map(to => {
      var _params$context2;
      return {
        id: this.connectorId,
        params: {
          to: [to],
          subject: params.subject,
          message: params.message,
          messageHTML: params.messageHTML
        },
        relatedSavedObjects: (_params$context2 = params.context) === null || _params$context2 === void 0 ? void 0 : _params$context2.relatedObjects
      };
    });
    const response = await this.actionsClient.bulkEnqueueExecution(this.requesterId, actions);
    if (response.errors) {
      this.logEnqueueExecutionResponse(response.items);
    }
  }
  async sendAttachmentEmail(params) {
    var _params$context3;
    const action = {
      requesterId: this.requesterId,
      id: this.connectorId,
      params: {
        to: params.to,
        subject: params.subject,
        message: params.message,
        bcc: params.bcc,
        cc: params.cc,
        attachments: params.attachments
      },
      relatedSavedObjects: (_params$context3 = params.context) === null || _params$context3 === void 0 ? void 0 : _params$context3.relatedObjects,
      spaceId: params.spaceId
    };
    const response = await this.actionsClient.execute(action);
    if (response.status === 'error') {
      throw new Error(response.message);
    }
  }
  logEnqueueExecutionResponse(items) {
    for (const r of items) {
      if (r.response === _create_execute_function.ExecutionResponseType.QUEUED_ACTIONS_LIMIT_ERROR) {
        this.logger.warn(`Skipped scheduling action "${r.id}" because the maximum number of queued actions has been reached.`);
      }
    }
  }
}
exports.ConnectorsEmailService = ConnectorsEmailService;