"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _utils = require("./utils");
var _top_nav_menu_popover = require("./top_nav_menu_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/top_nav_menu_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TopNavMenuItem = ({
  run,
  id,
  htmlId,
  label,
  testId,
  iconType,
  disableButton,
  href,
  target,
  isLoading,
  tooltipContent,
  tooltipTitle,
  items,
  isPopoverOpen,
  hidden,
  popoverWidth,
  onPopoverToggle,
  onPopoverClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const itemText = (0, _lodash.upperFirst)(label);
  const {
    title,
    content
  } = (0, _utils.getTooltip)({
    tooltipContent,
    tooltipTitle
  });
  const showTooltip = Boolean(content || title);
  const hasItems = items && items.length > 0;
  const handleClick = () => {
    if ((0, _utils.isDisabled)(disableButton)) return;
    if (hasItems) {
      onPopoverToggle();
      return;
    }
    run === null || run === void 0 ? void 0 : run();
  };
  const buttonCss = (0, _react2.css)`
    background-color: ${isPopoverOpen ? (0, _utils.getIsSelectedColor)({
    color: 'text',
    euiTheme,
    isFilled: false
  }) : undefined};
  `;
  const buttonComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: hidden !== null && hidden !== void 0 ? hidden : 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    onClick: href ? undefined : handleClick,
    id: htmlId,
    "data-test-subj": testId || `top-nav-menu-item-${id}`,
    iconType: iconType,
    isDisabled: (0, _utils.isDisabled)(disableButton),
    href: href,
    target: href ? target : undefined,
    isLoading: isLoading,
    size: "s",
    iconSide: "left",
    iconSize: "m",
    color: "text",
    "aria-haspopup": hasItems ? 'menu' : undefined,
    isSelected: hasItems ? isPopoverOpen : undefined,
    css: buttonCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, itemText));

  /**
   * There is an issue with passing down a button wrapped in a tooltip to popover.
   * Because of that, popover has its own tooltip handling.
   * So we only wrap in tooltip if there are no items (no popover).
   */
  const button = showTooltip && !hasItems ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: content,
    title: title,
    delay: "long",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, buttonComponent) : buttonComponent;
  if (hasItems) {
    return /*#__PURE__*/_react.default.createElement(_top_nav_menu_popover.TopNavMenuPopover, {
      items: items,
      anchorElement: button,
      tooltipContent: content,
      tooltipTitle: title,
      isOpen: isPopoverOpen,
      popoverWidth: popoverWidth,
      onClose: onPopoverClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    });
  }
  return button;
};
exports.TopNavMenuItem = TopNavMenuItem;