"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterStatus = ClusterStatus;
var _react = _interopRequireDefault(require("react"));
var _summary_status = require("../../summary_status");
var _format_number = require("../../../lib/format_number");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/cluster_status/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ClusterStatus({
  stats,
  alerts
}) {
  const {
    node_count: nodeCount,
    avg_memory_used: avgMemoryUsed,
    avg_memory: avgMemory,
    events_in_total: eventsInTotal,
    events_out_total: eventsOutTotal
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.logstash.clusterStatus.nodesLabel', {
      defaultMessage: 'Nodes'
    }),
    value: nodeCount,
    'data-test-subj': 'node_count'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.clusterStatus.memoryLabel', {
      defaultMessage: 'Memory'
    }),
    value: (0, _format_number.formatMetric)(avgMemoryUsed, 'byte') + ' / ' + (0, _format_number.formatMetric)(avgMemory, 'byte'),
    'data-test-subj': 'memory_used'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.clusterStatus.eventsReceivedLabel', {
      defaultMessage: 'Events Received'
    }),
    value: (0, _format_number.formatMetric)(eventsInTotal, '0.[0]a'),
    'data-test-subj': 'events_in_total'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.clusterStatus.eventsEmittedLabel', {
      defaultMessage: 'Events Emitted'
    }),
    value: (0, _format_number.formatMetric)(eventsOutTotal, '0.[0]a'),
    'data-test-subj': 'events_out_total'
  }];
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    alerts: alerts,
    "data-test-subj": "logstashClusterStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  });
}