"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTechnicalPreview = getTechnicalPreview;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Chart titles are taken from `metric.title` or `metric.label` fields in the series data.
 * Use title if found, otherwise use label
 */
function getTechnicalPreview(series = []) {
  return (0, _lodash.chain)(series.map(s => {
    return Boolean(s.metric.technicalPreview);
  })).first().value();
}