"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLargeShardSizeAlertType = createLargeShardSizeAlertType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _lazy_expression = require("../components/param_details_form/lazy_expression");
var _get_description_fields = require("../get_description_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/large_shard_size_alert/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const validate = inputValues => {
  const validationResult = {
    errors: {}
  };
  const errors = {
    indexPattern: []
  };
  if (!inputValues.indexPattern) {
    errors.indexPattern.push(_i18n.i18n.translate('xpack.monitoring.alerts.validation.indexPattern', {
      defaultMessage: 'A valid index pattern/s is required.'
    }));
  }
  validationResult.errors = errors;
  return validationResult;
};
function createLargeShardSizeAlertType(config) {
  return {
    id: _constants.RULE_LARGE_SHARD_SIZE,
    description: _constants.RULE_DETAILS[_constants.RULE_LARGE_SHARD_SIZE].description,
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.monitoring.alertsKibanaLargeShardSize}`;
    },
    ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_lazy_expression.LazyExpression, (0, _extends2.default)({}, props, {
      config: config,
      paramDetails: _constants.RULE_DETAILS[_constants.RULE_LARGE_SHARD_SIZE].paramDetails,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    })),
    validate,
    defaultActionMessage: '{{context.internalFullMessage}}',
    requiresAppContext: _constants.RULE_REQUIRES_APP_CONTEXT,
    getDescriptionFields: _get_description_fields.getDescriptionFields
  };
}