"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALIDATION_STATUS = exports.TRAINING_DOCS_UPPER = exports.TRAINING_DOCS_LOWER = exports.SKIP_BUCKET_SPAN_ESTIMATION = exports.NUM_CATEGORIES_THRESHOLD = exports.MINIMUM_NUM_FIELD_FOR_CHECK = exports.JOB_ID_MAX_LENGTH = exports.INCLUDED_FIELDS_THRESHOLD = exports.FRACTION_EMPTY_LIMIT = exports.ALL_CATEGORIES = exports.ALLOWED_DATA_UNITS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Interface for a callout message.
 */
/**
 * Type for the response of the validate analytics job API.
 */
/**
 * Enum for the validation status.
 */
let VALIDATION_STATUS = exports.VALIDATION_STATUS = /*#__PURE__*/function (VALIDATION_STATUS) {
  VALIDATION_STATUS["ERROR"] = "error";
  VALIDATION_STATUS["INFO"] = "info";
  VALIDATION_STATUS["SUCCESS"] = "success";
  VALIDATION_STATUS["WARNING"] = "warning";
  return VALIDATION_STATUS;
}({});
/**
 * Boolean const for skipping the bucket span estimation.
 */
const SKIP_BUCKET_SPAN_ESTIMATION = exports.SKIP_BUCKET_SPAN_ESTIMATION = true;

/**
 * Const for allowed data units.
 */
const ALLOWED_DATA_UNITS = exports.ALLOWED_DATA_UNITS = ['B', 'KB', 'MB', 'GB', 'TB', 'PB'];

/**
 * Const for the maximum length of a job ID.
 */
const JOB_ID_MAX_LENGTH = exports.JOB_ID_MAX_LENGTH = 64;

// Data Frame Analytics

/**
 * Const for the upper limit of training documents.
 */
const TRAINING_DOCS_UPPER = exports.TRAINING_DOCS_UPPER = 200000;

/**
 * Const for the lower limit of training documents.
 */
const TRAINING_DOCS_LOWER = exports.TRAINING_DOCS_LOWER = 200;

/**
 * Const for the threshold of included fields.
 */
const INCLUDED_FIELDS_THRESHOLD = exports.INCLUDED_FIELDS_THRESHOLD = 100;

/**
 * Const for the minimum number of fields for check.
 */
const MINIMUM_NUM_FIELD_FOR_CHECK = exports.MINIMUM_NUM_FIELD_FOR_CHECK = 25;

/**
 * Const for the fraction empty limit.
 */
const FRACTION_EMPTY_LIMIT = exports.FRACTION_EMPTY_LIMIT = 0.3;

/**
 * Const for the maximum length of categories.
 */
const NUM_CATEGORIES_THRESHOLD = exports.NUM_CATEGORIES_THRESHOLD = 10;

/**
 * Const for all categories.
 */
const ALL_CATEGORIES = exports.ALL_CATEGORIES = -1;