/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.ml_bundle_jsonpfunction=self.ml_bundle_jsonpfunction||[]).push([[6254],{36254:(e,a,t)=>{t.d(a,{pw:()=>y,HL:()=>D});var s=t(84286),i=t.n(s),n=t(75008),l=t(81319),d=t(26192),r=t(46293),c=t(96791);const o=n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteActionNameText",{defaultMessage:"Delete"}),u=({isDisabled:e,item:a})=>e?(0,c.jsx)(l.EuiToolTip,{position:"top",content:(0,r.isDataFrameAnalyticsRunning)(a.stats.state)?n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteActionDisabledToolTipContent",{defaultMessage:"Stop the data frame analytics job in order to delete it."}):(0,d.createPermissionFailureMessage)("canStartStopDataFrameAnalytics")},(0,c.jsx)("span",{tabIndex:0},o)):(0,c.jsx)(i().Fragment,null,o),y=({closeModal:e,deleteAndCloseModal:a,deleteTargetIndex:t,deleteDataView:s,dataViewExists:d,isLoading:r,item:o,toggleDeleteIndex:u,toggleDeleteDataView:y,userCanDeleteIndex:m,userCanDeleteDataView:g})=>{const f=(0,l.useGeneratedHtmlId)();if(void 0===o)return null;const x=o.config.dest.index;return(0,c.jsx)(l.EuiConfirmModal,{"data-test-subj":"mlAnalyticsJobDeleteModal","aria-labelledby":f,title:n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteModalTitle",{defaultMessage:"Delete {analyticsId}?",values:{analyticsId:o.config.id}}),titleProps:{id:f},onCancel:e,onConfirm:a,cancelButtonText:n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteModalCancelButton",{defaultMessage:"Cancel"}),confirmButtonText:n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteModalDeleteButton",{defaultMessage:"Delete"}),defaultFocusedButton:l.EUI_MODAL_CONFIRM_BUTTON,buttonColor:"danger",confirmButtonDisabled:r},(0,c.jsx)(l.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,c.jsx)(l.EuiFlexItem,null,m&&(0,c.jsx)(l.EuiSwitch,{"data-test-subj":"mlAnalyticsJobDeleteIndexSwitch",style:{paddingBottom:10},label:n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteDestinationIndexTitle",{defaultMessage:"Delete destination index {indexName}",values:{indexName:x}}),checked:t,onChange:u})),(0,c.jsx)(l.EuiFlexItem,null,m&&d&&(0,c.jsx)(i().Fragment,null,(0,c.jsx)(l.EuiSpacer,{size:"s"}),(0,c.jsx)(l.EuiSwitch,{"data-test-subj":"mlAnalyticsJobDeleteDataViewSwitch",label:n.i18n.translate("xpack.ml.dataframe.analyticsList.deleteTargetDataViewTitle",{defaultMessage:"Delete data view {dataView}",values:{dataView:x}}),checked:s,onChange:y,disabled:!1===g})))))};var m=t(43627),g=t(67140),f=t(21286),x=t(42775),p=t(87039);const D=e=>{const[a,t]=(0,s.useState)(),[i,l]=(0,s.useState)(!1),[d,y]=(0,s.useState)(!1),[D,A]=(0,s.useState)(!1),[I,S]=(0,s.useState)(!0),[M,T]=(0,s.useState)(!0),[v,E]=(0,s.useState)(!1),[h,w]=(0,s.useState)(!1),[b,k]=(0,s.useState)(!1),[L,C]=(0,s.useState)(!1),{data:{dataViews:F},application:{capabilities:j}}=(0,g.hk)().services,R=(0,p.$)(null==a?void 0:a.config),V=(0,f.useToastNotificationService)(),_=(0,x.br)(),N=(0,x.kU)(),J=(0,x.JB)();(0,s.useEffect)((()=>{C(!0),(async()=>{try{const e=(await F.getIdsWithTitle(!0)).find((({title:e})=>e===R));k(void 0!==e),C(!1)}catch(e){const a=(0,m.P)(e);C(!1),V.displayDangerToast(n.i18n.translate("xpack.ml.dataframe.analyticsList.errorWithCheckingIfDataViewExistsNotificationErrorMessage",{defaultMessage:"An error occurred checking if data view {dataView} exists: {error}",values:{dataView:R,error:a}}))}})(),(async()=>{try{await J(R)&&E(!0);const e=!0===j.savedObjectsManagement.delete||!0===j.indexPatterns.save;w(e),!1===e&&T(!1)}catch(e){const a=(0,m.P)(e);C(!1),V.displayDangerToast(n.i18n.translate("xpack.ml.dataframe.analyticsList.errorWithCheckingIfUserCanDeleteIndexNotificationErrorMessage",{defaultMessage:"An error occurred checking if user can delete {destinationIndex}: {error}",values:{destinationIndex:R,error:a}}))}})()}),[i]);const B=e=>{t(e),y(!0)};return{action:(0,s.useMemo)((()=>({name:a=>(0,c.jsx)(u,{isDisabled:(0,r.isDataFrameAnalyticsRunning)(a.stats.state)||!e,item:a}),enabled:a=>!(0,r.isDataFrameAnalyticsRunning)(a.stats.state)&&e,description:o,icon:"trash",type:"icon",onClick:e=>B(e),"data-test-subj":"mlAnalyticsJobDeleteButton"})),[]),closeDeleteJobCheckModal:()=>y(!1),closeModal:()=>l(!1),deleteAndCloseModal:()=>{A(!0),l(!1),void 0!==a&&(v&&I||v&&M?N(a.config,I,b&&M):_(a.config))},deleteTargetIndex:I,deleteDataView:M,deleteItem:D,dataViewExists:b,isDeleteJobCheckModalVisible:d,isModalVisible:i,isLoading:L,item:a,jobType:"data-frame-analytics",openModal:e=>{t(e),l(!0)},openDeleteJobCheckModal:B,toggleDeleteIndex:()=>S(!I),toggleDeleteDataView:()=>T(!M),userCanDeleteIndex:v,userCanDeleteDataView:h}}},42775:(e,a,t)=>{t.d(a,{JB:()=>u,br:()=>c,kU:()=>o,GC:()=>s.GC,CE:()=>y,Ku:()=>g});var s=t(69110),i=t(75008),n=t(43627),l=t(67140),d=t(21286),r=t(83721);const c=()=>{const e=(0,d.useToastNotificationService)(),a=(0,l.nK)();return async t=>{try{await a.dataFrameAnalytics.deleteDataFrameAnalytics(t.id),e.displaySuccessToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsSuccessMessage",{defaultMessage:"Request to delete data frame analytics job {analyticsId} acknowledged.",values:{analyticsId:t.id}}))}catch(a){e.displayErrorToast(a,i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsErrorMessage",{defaultMessage:"An error occurred deleting the data frame analytics job {analyticsId}",values:{analyticsId:t.id}}))}r.refreshAnalyticsList$.next(r.REFRESH_ANALYTICS_LIST_STATE.REFRESH)}},o=()=>{const e=(0,d.useToastNotificationService)(),a=(0,l.nK)();return async(t,s,l)=>{const d=t.dest.index;try{var c,o,u,y,m,g;const r=await a.dataFrameAnalytics.deleteDataFrameAnalyticsAndDestIndex(t.id,s,l);if(null!==(c=r.analyticsJobDeleted)&&void 0!==c&&c.success&&e.displaySuccessToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsSuccessMessage",{defaultMessage:"Request to delete data frame analytics job {analyticsId} acknowledged.",values:{analyticsId:t.id}})),null!==(o=r.analyticsJobDeleted)&&void 0!==o&&o.error&&e.displayErrorToast(r.analyticsJobDeleted.error,i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsErrorMessage",{defaultMessage:"An error occurred deleting the data frame analytics job {analyticsId}",values:{analyticsId:t.id}})),null!==(u=r.destIndexDeleted)&&void 0!==u&&u.success&&e.displaySuccessToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsWithIndexSuccessMessage",{defaultMessage:"Request to delete destination index {destinationIndex} acknowledged.",values:{destinationIndex:d}})),null!==(y=r.destIndexDeleted)&&void 0!==y&&y.error&&e.displayErrorToast(r.destIndexDeleted.error,i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsWithIndexErrorMessage",{defaultMessage:"An error occurred deleting destination index {destinationIndex}",values:{destinationIndex:d}})),null!==(m=r.destDataViewDeleted)&&void 0!==m&&m.success&&e.displaySuccessToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsWithDataViewSuccessMessage",{defaultMessage:"Request to delete data view {destinationIndex} acknowledged.",values:{destinationIndex:d}})),null!==(g=r.destDataViewDeleted)&&void 0!==g&&g.error){const a=(0,n.P)(r.destDataViewDeleted.error);e.displayDangerToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsWithDataViewErrorMessage",{defaultMessage:"An error occurred deleting data view {destinationIndex}: {error}",values:{destinationIndex:d,error:a}}))}}catch(a){e.displayErrorToast(a,i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsErrorMessage",{defaultMessage:"An error occurred deleting the data frame analytics job {analyticsId}",values:{analyticsId:t.id}}))}r.refreshAnalyticsList$.next(r.REFRESH_ANALYTICS_LIST_STATE.REFRESH)}},u=()=>{const e=(0,d.useToastNotificationService)(),a=(0,l.nK)();return async t=>{try{const e=await a.hasPrivileges({index:[{names:[t],privileges:["delete_index"]}]});return!!e&&(void 0===e.hasPrivileges||!0===e.hasPrivileges.has_all_requested)}catch(a){const s=(0,n.P)(a);e.displayDangerToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.deleteAnalyticsPrivilegeErrorMessage",{defaultMessage:"User does not have permission to delete index {indexName}: {error}",values:{indexName:t,error:s}}))}}},y=()=>{const e=(0,d.useToastNotificationService)(),a=(0,l.nK)();return async t=>{try{await a.dataFrameAnalytics.startDataFrameAnalytics(t.config.id),e.displaySuccessToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.startAnalyticsSuccessMessage",{defaultMessage:"Request to start data frame analytics {analyticsId} acknowledged.",values:{analyticsId:t.config.id}}))}catch(a){e.displayErrorToast(a,i.i18n.translate("xpack.ml.dataframe.analyticsList.startAnalyticsErrorTitle",{defaultMessage:"Error starting job"}))}r.refreshAnalyticsList$.next(r.REFRESH_ANALYTICS_LIST_STATE.REFRESH)}};var m=t(46293);const g=()=>{const e=(0,d.useToastNotificationService)(),a=(0,l.nK)();return async t=>{try{await a.dataFrameAnalytics.stopDataFrameAnalytics(t.config.id,(0,m.isDataFrameAnalyticsFailed)(t.stats.state)),e.displaySuccessToast(i.i18n.translate("xpack.ml.dataframe.analyticsList.stopAnalyticsSuccessMessage",{defaultMessage:"Request to stop data frame analytics {analyticsId} acknowledged.",values:{analyticsId:t.config.id}}))}catch(a){e.displayErrorToast(a,i.i18n.translate("xpack.ml.dataframe.analyticsList.stopAnalyticsErrorMessage",{defaultMessage:"An error occurred stopping the data frame analytics {analyticsId}: {error}",values:{analyticsId:t.config.id,error:JSON.stringify(a)}}))}r.refreshAnalyticsList$.next(r.REFRESH_ANALYTICS_LIST_STATE.REFRESH)}}}}]);