"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomalyChartsReactEmbeddableFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react = _interopRequireDefault(require("react"));
var _presentationUtil = require("@kbn/presentation-util");
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _ = require("..");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _initialize_anomaly_charts_controls = require("./initialize_anomaly_charts_controls");
var _lazy_anomaly_charts_container = require("./lazy_anomaly_charts_container");
var _get_anomaly_charts_services_dependencies = require("./get_anomaly_charts_services_dependencies");
var _build_data_view_publishing_api = require("../common/build_data_view_publishing_api");
var _anomaly_charts_setup_flyout = require("./anomaly_charts_setup_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/anomaly_charts/anomaly_charts_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAnomalyChartsReactEmbeddableFactory = getStartServices => {
  const factory = {
    type: _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
        throw new Error('Parent API does not have execution context');
      }
      const [coreStartServices, pluginsStartServices] = await getStartServices();
      const anomalyChartsDependencies = await (0, _get_anomaly_charts_services_dependencies.getAnomalyChartsServiceDependencies)(coreStartServices, pluginsStartServices);
      const [,, mlServices] = anomalyChartsDependencies;
      const subscriptions = new _rxjs.Subscription();
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const chartsManager = (0, _initialize_anomaly_charts_controls.initializeAnomalyChartsControls)(initialState.rawState, titleManager.api, parentApi);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...timeRangeManager.getLatestState(),
            ...chartsManager.getLatestState()
          },
          references: []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, timeRangeManager.anyStateChange$, chartsManager.anyStateChange$),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            ..._presentationPublishing.timeRangeComparators,
            ..._initialize_anomaly_charts_controls.anomalyChartsComparators
          };
        },
        onReset: lastSaved => {
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved) chartsManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.typeDisplayName', {
          defaultMessage: 'anomaly charts'
        }),
        onEdit: async () => {
          (0, _presentationUtil.openLazyFlyout)({
            core: coreStartServices,
            parentApi,
            flyoutProps: {
              'data-test-subj': 'mlAnomalyChartsEmbeddableInitializer',
              focusedPanelId: uuid
            },
            loadContent: async ({
              closeFlyout
            }) => {
              return /*#__PURE__*/_react.default.createElement(_anomaly_charts_setup_flyout.EmbeddableAnomalyChartsUserInput, {
                coreStart: coreStartServices,
                pluginStart: pluginsStartServices,
                onConfirm: result => {
                  chartsManager.api.updateUserInput(result);
                  closeFlyout();
                },
                onCancel: closeFlyout,
                input: {
                  ...titleManager.getLatestState(),
                  ...chartsManager.getLatestState()
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 121,
                  columnNumber: 17
                }
              });
            }
          });
        },
        ...titleManager.api,
        ...timeRangeManager.api,
        ...chartsManager.api,
        ...chartsManager.dataLoadingApi,
        ...unsavedChangesApi,
        dataViews$: (0, _build_data_view_publishing_api.buildDataViewPublishingApi)({
          anomalyDetectorService: mlServices.anomalyDetectorService,
          dataViewsService: pluginsStartServices.data.dataViews
        }, {
          jobIds: chartsManager.api.jobIds$
        }, subscriptions),
        serializeState
      });
      const appliedTimeRange$ = (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => fetchContext.timeRange), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default));
      const {
        onRenderComplete,
        onLoading,
        onError
      } = chartsManager.dataLoadingApi;
      const contextServices = {
        mlServices: {
          ...mlServices
        },
        ...coreStartServices,
        ...pluginsStartServices
      };
      return {
        api,
        Component: () => {
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          (0, _use_embeddable_execution_context.useReactEmbeddableExecutionContext)(coreStartServices.executionContext, parentApi.executionContext, _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE, uuid);
          (0, _useUnmount.default)(() => {
            chartsManager.cleanup();
            subscriptions.unsubscribe();
          });
          const {
            euiTheme
          } = (0, _eui.useEuiTheme)();
          return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStartServices, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 186,
              columnNumber: 13
            }
          }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
            services: contextServices,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 187,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement("div", {
            css: (0, _react2.css)`
                    width: 100%;
                    padding: ${euiTheme.size.xs};
                    overflow-y: auto;
                  `,
            "data-test-subj": "mlAnomalySwimlaneEmbeddableWrapper",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 188,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_lazy_anomaly_charts_container.LazyAnomalyChartsContainer, {
            id: uuid,
            severityThreshold: initialState.rawState.severityThreshold,
            api: api,
            services: anomalyChartsDependencies,
            onLoading: onLoading,
            onRenderComplete: onRenderComplete,
            onError: onError,
            timeRange$: appliedTimeRange$,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 196,
              columnNumber: 19
            }
          }))));
        }
      };
    }
  };
  return factory;
};
exports.getAnomalyChartsReactEmbeddableFactory = getAnomalyChartsReactEmbeddableFactory;