"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getViewableDetectors = getViewableDetectors;
var _job_utils = require("../../../../common/util/job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getViewableDetectors(selectedJob) {
  const jobDetectors = selectedJob.analysis_config.detectors;
  const viewableDetectors = [];
  jobDetectors.forEach((dtr, index) => {
    if ((0, _job_utils.isTimeSeriesViewDetector)(selectedJob, index)) {
      viewableDetectors.push({
        index,
        detector_description: dtr.detector_description,
        function: dtr.function
      });
    }
  });
  return viewableDetectors;
}