"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLanguage = getLanguage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const langCodes = {
  af: 'Afrikaans',
  hr: 'Croatian',
  pa: 'Punjabi',
  am: 'Amharic',
  ht: 'Haitian',
  pl: 'Polish',
  ar: 'Arabic',
  hu: 'Hungarian',
  ps: 'Pashto',
  az: 'Azerbaijani',
  hy: 'Armenian',
  pt: 'Portuguese',
  be: 'Belarusian',
  id: 'Indonesian',
  ro: 'Romanian',
  bg: 'Bulgarian',
  ig: 'Igbo',
  ru: 'Russian',
  'bg-Latn': 'Bulgarian',
  is: 'Icelandic',
  'ru-Latn': 'Russian',
  bn: 'Bengali',
  it: 'Italian',
  sd: 'Sindhi',
  bs: 'Bosnian',
  iw: 'Hebrew',
  si: 'Sinhala',
  ca: 'Catalan',
  ja: 'Japanese',
  sk: 'Slovak',
  ceb: 'Cebuano',
  'ja-Latn': 'Japanese',
  sl: 'Slovenian',
  co: 'Corsican',
  jv: 'Javanese',
  sm: 'Samoan',
  cs: 'Czech',
  ka: 'Georgian',
  sn: 'Shona',
  cy: 'Welsh',
  kk: 'Kazakh',
  so: 'Somali',
  da: 'Danish',
  km: 'Central Khmer',
  sq: 'Albanian',
  de: 'German',
  kn: 'Kannada',
  sr: 'Serbian',
  el: 'Greek,modern',
  ko: 'Korean',
  st: 'Southern Sotho',
  'el-Latn': 'Greek,modern',
  ku: 'Kurdish',
  su: 'Sundanese',
  en: 'English',
  ky: 'Kirghiz',
  sv: 'Swedish',
  eo: 'Esperanto',
  la: 'Latin',
  sw: 'Swahili',
  es: 'Spanish,Castilian',
  lb: 'Luxembourgish',
  ta: 'Tamil',
  et: 'Estonian',
  lo: 'Lao',
  te: 'Telugu',
  eu: 'Basque',
  lt: 'Lithuanian',
  tg: 'Tajik',
  fa: 'Persian',
  lv: 'Latvian',
  th: 'Thai',
  fi: 'Finnish',
  mg: 'Malagasy',
  tr: 'Turkish',
  fil: 'Filipino',
  mi: 'Maori',
  uk: 'Ukrainian',
  fr: 'French',
  mk: 'Macedonian',
  ur: 'Urdu',
  fy: 'Western Frisian',
  ml: 'Malayalam',
  uz: 'Uzbek',
  ga: 'Irish',
  mn: 'Mongolian',
  vi: 'Vietnamese',
  gd: 'Gaelic',
  mr: 'Marathi',
  xh: 'Xhosa',
  gl: 'Galician',
  ms: 'Malay',
  yi: 'Yiddish',
  gu: 'Gujarati',
  mt: 'Maltese',
  yo: 'Yoruba',
  ha: 'Hausa',
  my: 'Burmese',
  zh: 'Chinese',
  haw: 'Hawaiian',
  ne: 'Nepali',
  'zh-Latn': 'Chinese',
  hi: 'Hindi',
  nl: 'Dutch,Flemish',
  zu: 'Zulu',
  'hi-Latn': 'Hindi',
  no: 'Norwegian',
  hmn: 'Hmong',
  ny: 'Chichewa',
  zxx: 'unknown'
};
function getLanguage(code) {
  var _langCodes$code;
  return (_langCodes$code = langCodes[code]) !== null && _langCodes$code !== void 0 ? _langCodes$code : 'unknown';
}