"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDITOR_MODE = exports.DatafeedPreviewFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../job_creator_context");
var _datafeed_preview = require("./datafeed_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/common/datafeed_preview_flyout/datafeed_preview_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let EDITOR_MODE = exports.EDITOR_MODE = /*#__PURE__*/function (EDITOR_MODE) {
  EDITOR_MODE[EDITOR_MODE["HIDDEN"] = 0] = "HIDDEN";
  EDITOR_MODE[EDITOR_MODE["READONLY"] = 1] = "READONLY";
  EDITOR_MODE[EDITOR_MODE["EDITABLE"] = 2] = "EDITABLE";
  return EDITOR_MODE;
}({});
const DatafeedPreviewFlyout = ({
  isDisabled
}) => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  function toggleFlyout() {
    setShowFlyout(!showFlyout);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleFlyout,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), showFlyout === true && isDisabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": flyoutTitleId,
    onClose: () => setShowFlyout(false),
    hideCloseButton: true,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_datafeed_preview.DatafeedPreview, {
    flyoutTitleId: flyoutTitleId,
    combinedJob: {
      ...jobCreator.jobConfig,
      datafeed_config: jobCreator.datafeedConfig
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => setShowFlyout(false),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedPreviewFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 19
    }
  })))))));
};
exports.DatafeedPreviewFlyout = DatafeedPreviewFlyout;
const FlyoutButton = ({
  isDisabled,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobWizardButtonPreviewJobJson",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedPreviewFlyout.showButton",
    defaultMessage: "Datafeed preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};