"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencersStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _state_service = require("../services/state_service");
var _explorer_constants = require("./explorer_constants");
var _explorer_utils = require("./explorer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InfluencersStateService extends _state_service.StateService {
  constructor(mlApi, timefilter, anomalyExplorerCommonStateService, anomalyTimelineStateService) {
    super();
    (0, _defineProperty2.default)(this, "_influencers$", new _rxjs.BehaviorSubject({}));
    (0, _defineProperty2.default)(this, "_isLoading$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "_timeBounds$", void 0);
    (0, _defineProperty2.default)(this, "_refresh$", _mlDatePicker.mlTimefilterRefresh$.pipe((0, _rxjs.startWith)({
      lastRefresh: 0
    })));
    this.mlApi = mlApi;
    this.timefilter = timefilter;
    this.anomalyExplorerCommonStateService = anomalyExplorerCommonStateService;
    this.anomalyTimelineStateService = anomalyTimelineStateService;
    this._timeBounds$ = this.timefilter.getTimeUpdate$().pipe((0, _rxjs.startWith)(null), (0, _rxjs.map)(() => this.timefilter.getBounds()));
    this._init();
  }
  get influencers$() {
    return this._influencers$.asObservable();
  }
  get influencers() {
    return this._influencers$.getValue();
  }
  get isLoading$() {
    return this._isLoading$.asObservable();
  }
  _initSubscriptions() {
    const subscription = new _rxjs.Subscription();
    subscription.add((0, _rxjs.combineLatest)([this.anomalyExplorerCommonStateService.selectedJobs$, this.anomalyTimelineStateService.getSelectedCells$(), this.anomalyTimelineStateService.getViewBySwimlaneFieldName$(), this.anomalyExplorerCommonStateService.influencerFilterQuery$, this._timeBounds$, this._refresh$]).pipe(
    // selectedCells is initially undefined, so we skip until it's loaded
    (0, _rxjs.skipWhile)(([, selectedCells]) => selectedCells === undefined), (0, _rxjs.switchMap)(([selectedJobs, selectedCells, viewByFieldName, influencersFilterQuery]) => {
      const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, viewByFieldName);
      const jobIds = (0, _explorer_utils.getSelectionJobIds)(selectedCells, selectedJobs);
      const timerange = (0, _explorer_utils.getSelectionTimeRange)(selectedCells, this.timefilter.getBounds());
      this._isLoading$.next(true);
      return this._getTopInfluencers({
        jobIds,
        earliestMs: timerange.earliestMs,
        latestMs: timerange.latestMs,
        influencers: selectionInfluencers.map(s => {
          var _s$fieldValue;
          return {
            fieldName: s.fieldName,
            fieldValue: String((_s$fieldValue = s.fieldValue) !== null && _s$fieldValue !== void 0 ? _s$fieldValue : '')
          };
        }),
        influencersFilterQuery
      });
    })).subscribe(({
      influencers
    }) => {
      this._influencers$.next(influencers);
      this._isLoading$.next(false);
    }));
    return subscription;
  }
  _getTopInfluencers({
    jobIds,
    earliestMs,
    latestMs,
    influencers,
    influencersFilterQuery
  }) {
    const payload = {
      jobIds,
      earliestMs,
      latestMs,
      maxFieldValues: _explorer_constants.MAX_INFLUENCER_FIELD_VALUES,
      ...(Array.isArray(influencers) && influencers.length > 0 ? {
        influencers
      } : {}),
      ...(influencersFilterQuery ? {
        influencersFilterQuery
      } : {})
    };
    return (0, _rxjs.from)(this.mlApi.results.getTopInfluencers(payload)).pipe((0, _rxjs.map)(response => ({
      influencers: response
    })));
  }
}
exports.InfluencersStateService = InfluencersStateService;