"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAnalyticsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/create_analytics_button/create_analytics_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateAnalyticsButton = ({
  isDisabled,
  navigateToSourceSelection,
  size = 's'
}) => {
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isDisabled,
    fill: true,
    onClick: navigateToSourceSelection,
    iconType: "plusInCircle",
    size: size,
    "data-test-subj": "mlAnalyticsButtonCreate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.createDataFrameAnalyticsButton', {
    defaultMessage: 'Create job'
  }));
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _check_capabilities.createPermissionFailureMessage)('canCreateDataFrameAnalytics'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }, button);
  }
  return button;
};
exports.CreateAnalyticsButton = CreateAnalyticsButton;