"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationStepDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _data_source_context = require("../../../../../contexts/ml/data_source_context");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _page = require("../../page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/configuration_step/configuration_step_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_INCLUDES_LENGTH = 5;
const ConfigurationStepDetails = ({
  setCurrentStep,
  state
}) => {
  const {
    selectedDataView
  } = (0, _data_source_context.useDataSource)();
  const {
    form,
    isJobCreated
  } = state;
  const {
    dependentVariable,
    includes,
    jobConfigQueryString,
    jobType,
    trainingPercent
  } = form;
  const isJobTypeWithDepVar = jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION;
  const detailsFirstCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.sourceIndex', {
      defaultMessage: 'Source index'
    }),
    description: selectedDataView.title || _state.UNSET_CONFIG_ITEM
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.Query', {
      defaultMessage: 'Query'
    }),
    description: jobConfigQueryString || _state.UNSET_CONFIG_ITEM
  }];
  const detailsSecondCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.jobType', {
      defaultMessage: 'Job type'
    }),
    description: jobType
  }];
  const detailsThirdCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.includedFields', {
      defaultMessage: 'Included fields'
    }),
    description: includes.length > MAX_INCLUDES_LENGTH ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.includedFieldsAndMoreDescription', {
      defaultMessage: '{includedFields} ... (and {extraCount} more)',
      values: {
        extraCount: includes.length - MAX_INCLUDES_LENGTH,
        includedFields: includes.slice(0, MAX_INCLUDES_LENGTH).join(', ')
      }
    }) : includes.join(', ')
  }];
  if (isJobTypeWithDepVar) {
    detailsSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.trainingPercent', {
        defaultMessage: 'Training percent'
      }),
      description: `${trainingPercent}`
    });
    detailsThirdCol.unshift({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.dependentVariable', {
        defaultMessage: 'Dependent variable'
      }),
      description: dependentVariable
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsFirstCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsSecondCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsThirdCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.CONFIGURATION);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.editButtonText', {
    defaultMessage: 'Edit'
  })));
};
exports.ConfigurationStepDetails = ConfigurationStepDetails;