"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewAndCreatePipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../contexts/kibana");
var _reindex_with_pipeline = require("../ml_inference/components/reindex_with_pipeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/shared/review_and_create_pipeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MANAGEMENT_APP_ID = 'management';
function getFieldFromPipelineConfig(config) {
  const {
    processors
  } = config;
  let field = '';
  if (processors !== null && processors !== void 0 && processors.length) {
    var _processors$0$inferen, _processors$0$inferen2;
    field = Object.keys((_processors$0$inferen = (_processors$0$inferen2 = processors[0].inference) === null || _processors$0$inferen2 === void 0 ? void 0 : _processors$0$inferen2.field_map) !== null && _processors$0$inferen !== void 0 ? _processors$0$inferen : {})[0];
  }
  return field;
}
const ReviewAndCreatePipeline = ({
  highlightTargetField = false,
  inferencePipeline,
  modelType,
  pipelineName,
  pipelineCreated,
  pipelineError,
  sourceIndex
}) => {
  var _application$capabili, _application$capabili2;
  const {
    services: {
      application,
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [isNextStepsAccordionOpen, setIsNextStepsAccordionOpen] = (0, _react.useState)('closed');
  const inferenceProcessorLink = modelType === 'regression' ? links.ingest.inferenceRegression : links.ingest.inferenceClassification;
  const accordionId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const targetedField = (0, _react.useMemo)(() => getFieldFromPipelineConfig(inferencePipeline), [inferencePipeline]);
  const configCodeBlock = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: "400px",
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStepConfigBlock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, JSON.stringify(inferencePipeline !== null && inferencePipeline !== void 0 ? inferencePipeline : {}, null, 2)), [inferencePipeline]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStep",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, pipelineCreated === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.title', {
    defaultMessage: "Review the pipeline configuration for ''{pipelineName}''",
    values: {
      pipelineName
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }), pipelineCreated === true && pipelineError === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStepSuccessCallout",
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.successMessage', {
      defaultMessage: "''{pipelineName}'' has been created successfully.",
      values: {
        pipelineName
      }
    }),
    color: "success",
    iconType: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.reIndexingMessage",
    defaultMessage: "You can use this pipeline to infer against new data or infer against existing data by {reindexLink} with the pipeline.",
    values: {
      reindexLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setIsNextStepsAccordionOpen('open'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 25
        }
      }, 'reindexing')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 19
    }
  }), (_application$capabili = application.capabilities.management) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.ingest) !== null && _application$capabili2 !== void 0 && _application$capabili2.ingest_pipelines ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.ingestPipelinesManagementMessage",
    defaultMessage: " Navigate to {pipelineManagementLink} to view and manage pipelines.",
    values: {
      pipelineManagementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: async () => {
          await application.navigateToApp(MANAGEMENT_APP_ID, {
            path: `/ingest/ingest_pipelines/?pipeline=${pipelineName}`,
            openInNewTab: true
          });
        },
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 27
        }
      }, 'Ingest Pipelines')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 21
    }
  }) : null)) : null, pipelineError !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.failureMessage', {
      defaultMessage: "Unable to create ''{pipelineName}''.",
      values: {
        pipelineName
      }
    }),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }, pipelineError), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.docLinkInErrorMessage",
    defaultMessage: "Learn more about {ingestPipelineConfigLink} and {inferencePipelineConfigLink} configuration.",
    values: {
      ingestPipelineConfigLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: links.ingest.pipelines,
        external: true,
        target: '_blank',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 25
        }
      }, 'ingest pipeline'),
      inferencePipelineConfigLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: modelType ? inferenceProcessorLink : links.ingest.inference,
        external: true,
        target: '_blank',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 25
        }
      }, 'inference processor')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 19
    }
  }))) : null)), highlightTargetField ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.targetFieldDescription",
    defaultMessage: "The field {field} will be targeted by the model for evaluation.",
    values: {
      field: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "accent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 34
        }
      }, targetedField)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, pipelineCreated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.nextStepsLabel",
      defaultMessage: "Next steps",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 19
      }
    }),
    forceState: isNextStepsAccordionOpen,
    onToggle: isOpen => {
      setIsNextStepsAccordionOpen(isOpen ? 'open' : 'closed');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reindex_with_pipeline.ReindexWithPipeline, {
    pipelineName: pipelineName,
    sourceIndex: sourceIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 17
    }
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 9
    }
  }, pipelineCreated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.viewConfig",
      defaultMessage: "View configuration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }, configCodeBlock)) : [configCodeBlock])));
};
exports.ReviewAndCreatePipeline = ReviewAndCreatePipeline;