"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckboxShowCharts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _anomaly_explorer_context = require("../../../explorer/anomaly_explorer_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/controls/checkbox_showcharts/checkbox_showcharts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * React component for a checkbox element to toggle charts display.
 */
const CheckboxShowCharts = () => {
  const {
    chartsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const showCharts = (0, _useObservable.default)(chartsStateService.getShowCharts$(), chartsStateService.getShowCharts());
  const onChange = (0, _react.useCallback)(e => {
    chartsStateService.setShowCharts(e.target.checked);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const id = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.controls.checkboxShowCharts.showChartsCheckboxLabel",
      defaultMessage: "Show charts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }),
    checked: showCharts,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
};
exports.CheckboxShowCharts = CheckboxShowCharts;