"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestsSelectionControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _alerts = require("../../../common/util/alerts");
var _alerts2 = require("../../../common/constants/alerts");
var _time_interval_control = require("../time_interval_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/jobs_health_rule/tests_selection_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TestsSelectionControl = exports.TestsSelectionControl = /*#__PURE__*/_react.default.memo(({
  config,
  onChange,
  errors
}) => {
  const uiConfig = (0, _alerts.getResultJobsHealthRuleConfig)(config);
  const updateCallback = (0, _react.useCallback)(update => {
    onChange({
      ...(config !== null && config !== void 0 ? config : {}),
      ...update
    });
  }, [onChange, config]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    isInvalid: !!(errors !== null && errors !== void 0 && errors.length),
    error: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, Object.entries(uiConfig).map(([name, conf], i) => {
    var _HEALTH_CHECK_NAMES$n, _HEALTH_CHECK_NAMES$n2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      key: name,
      title: /*#__PURE__*/_react.default.createElement("h4", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 24
        }
      }, (_HEALTH_CHECK_NAMES$n = _alerts2.HEALTH_CHECK_NAMES[name]) === null || _HEALTH_CHECK_NAMES$n === void 0 ? void 0 : _HEALTH_CHECK_NAMES$n.name),
      description: (_HEALTH_CHECK_NAMES$n2 = _alerts2.HEALTH_CHECK_NAMES[name]) === null || _HEALTH_CHECK_NAMES$n2 === void 0 ? void 0 : _HEALTH_CHECK_NAMES$n2.description,
      fullWidth: true,
      gutterSize: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.enableTestLabel",
        defaultMessage: "Enable",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 23
        }
      }),
      onChange: updateCallback.bind(null, {
        [name]: {
          ...uiConfig[name],
          enabled: !uiConfig[name].enabled
        }
      }),
      checked: uiConfig[name].enabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 19
      }
    })), name === 'delayedData' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.docsCountLabel",
        defaultMessage: "Number of documents",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.docsCountHint",
          defaultMessage: "The threshold for the amount of missing documents to alert upon.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 31
          }
        }),
        type: "question",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 27
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: uiConfig.delayedData.docsCount,
      onChange: e => {
        updateCallback({
          [name]: {
            ...uiConfig[name],
            docsCount: Number(e.target.value)
          }
        });
      },
      min: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_time_interval_control.TimeIntervalControl, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.timeIntervalLabel",
        defaultMessage: "Time interval",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.alertTypes.jobsHealthAlertingRule.testsSelection.delayedData.timeIntervalHint",
          defaultMessage: "The lookback interval to check during rule execution for delayed data. By default derived from the longest bucket span and query delay.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 31
          }
        }),
        type: "question",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 27
        }
      })),
      value: uiConfig.delayedData.timeInterval,
      onChange: e => {
        updateCallback({
          [name]: {
            ...uiConfig[name],
            timeInterval: e
          }
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 21
      }
    })) : null);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }));
});