"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTextPart = isTextPart;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Details about the MCP client.
 */

/**
 * Options for the MCP client.
 * These map to reconnection options for the StreamableHTTPClientTransport.
 */

/**
 * Parameters for calling a tool on the MCP client.
 */

/**
 * Non-text content as part of a tool call response.
 */

/**
 * A text content as part of a tool call response.
 */

/**
 * Type guard to check if a content part is a valid text part.
 * @param part - The content part to check
 */
function isTextPart(part) {
  return part !== null && part !== undefined && part.type === 'text' && typeof part.text === 'string';
}

/**
 * Response from calling a tool on the MCP client.
 */

/**
 * Metadata about the provider of a tool.
 * Used for attribution, audit trails, and UI display.
 */

/**
 * A tool available on the MCP client.
 */

/**
 * Response from listing the tools available on the MCP client.
 */