"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styleSchema = exports.heatmapStyleSchema = exports.EMSVectorTileStyleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../common/constants");
var _vector_style_schemas = require("./vector_style_schemas/vector_style_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMSVectorTileStyleSchema = exports.EMSVectorTileStyleSchema = _configSchema.schema.object({
  color: _configSchema.schema.string(),
  type: _configSchema.schema.literal(_constants.LAYER_STYLE_TYPE.EMS_VECTOR_TILE)
}, {
  meta: {
    description: 'Elastic Maps Service (EMS) Vector Tile style configuration.'
  }
});
const heatmapStyleSchema = exports.heatmapStyleSchema = _configSchema.schema.object({
  colorRampName: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('Blues'), _configSchema.schema.literal('Greens'), _configSchema.schema.literal('Greys'), _configSchema.schema.literal('Reds'), _configSchema.schema.literal('Yellow to Red'), _configSchema.schema.literal('Green to Red'), _configSchema.schema.literal('Blue to Red'), _configSchema.schema.literal('theclassic')], {
    defaultValue: 'theclassic'
  })),
  type: _configSchema.schema.literal(_constants.LAYER_STYLE_TYPE.HEATMAP)
}, {
  meta: {
    description: 'Heatmap style configuration.'
  }
});
const styleSchema = exports.styleSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  type: _configSchema.schema.string()
}, {
  unknowns: 'allow'
}), EMSVectorTileStyleSchema, heatmapStyleSchema, _vector_style_schemas.vectorStyleSchema]);