"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.percentileAggSchema = exports.fieldedAggSchema = exports.countAggSchema = exports.ESPewPewSourceSchema = exports.ESGeoLineSourceSchema = exports.ESGeoGridSourceSchema = exports.BaseESAggSourceSchema = exports.AggSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../common");
var _constants = require("../../../../../common/constants");
var _es_source_schemas = require("./es_source_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggMaskSchema = _configSchema.schema.object({
  operator: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.MASK_OPERATOR.ABOVE), _configSchema.schema.literal(_constants.MASK_OPERATOR.BELOW)]),
  value: _configSchema.schema.number()
}, {
  meta: {
    description: 'Hide cluster when metric value meets mask criteria.'
  }
});
const countAggSchema = exports.countAggSchema = _configSchema.schema.object({
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  mask: _configSchema.schema.maybe(aggMaskSchema),
  type: _configSchema.schema.literal(_constants.AGG_TYPE.COUNT)
});
const fieldedAggSchema = exports.fieldedAggSchema = _configSchema.schema.object({
  field: _configSchema.schema.maybe(_configSchema.schema.string()),
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  mask: _configSchema.schema.maybe(aggMaskSchema),
  type: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.AGG_TYPE.UNIQUE_COUNT), _configSchema.schema.literal(_constants.AGG_TYPE.MAX), _configSchema.schema.literal(_constants.AGG_TYPE.MIN), _configSchema.schema.literal(_constants.AGG_TYPE.SUM), _configSchema.schema.literal(_constants.AGG_TYPE.AVG), _configSchema.schema.literal(_constants.AGG_TYPE.TERMS)])
});
const percentileAggSchema = exports.percentileAggSchema = _configSchema.schema.object({
  field: _configSchema.schema.maybe(_configSchema.schema.string()),
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  mask: _configSchema.schema.maybe(aggMaskSchema),
  percentile: _configSchema.schema.maybe(_configSchema.schema.number()),
  type: _configSchema.schema.literal(_constants.AGG_TYPE.PERCENTILE)
});
const AggSchema = exports.AggSchema = _configSchema.schema.oneOf([countAggSchema, fieldedAggSchema, percentileAggSchema]);

// base schema for Elasticsearch DSL aggregation sources
const BaseESAggSourceSchema = exports.BaseESAggSourceSchema = _es_source_schemas.BaseESSourceSchema.extends({
  metrics: _configSchema.schema.maybe(_configSchema.schema.arrayOf(AggSchema, {
    defaultValue: [{
      type: _constants.AGG_TYPE.COUNT
    }]
  }))
});
const ESGeoGridSourceSchema = exports.ESGeoGridSourceSchema = BaseESAggSourceSchema.extends({
  geoField: _configSchema.schema.string({
    meta: {
      description: 'Field containing indexed geo-point or geo-shape values.'
    }
  }),
  requestType: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.RENDER_AS.HEATMAP), _configSchema.schema.literal(_constants.RENDER_AS.POINT), _configSchema.schema.literal(_constants.RENDER_AS.GRID), _configSchema.schema.literal(_constants.RENDER_AS.HEX)]),
  resolution: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.GRID_RESOLUTION.COARSE), _configSchema.schema.literal(_constants.GRID_RESOLUTION.FINE), _configSchema.schema.literal(_constants.GRID_RESOLUTION.MOST_FINE), _configSchema.schema.literal(_constants.GRID_RESOLUTION.SUPER_FINE)]),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ES_GEO_GRID)
}, {
  meta: {
    description: 'Vector feature source returning points and polygons from Elasticsearch geotile_grid or geohex_grid aggregations. One feature is returned per bucket.'
  },
  unknowns: 'forbid'
});
const ESGeoLineSourceSchema = exports.ESGeoLineSourceSchema = BaseESAggSourceSchema.extends({
  geoField: _configSchema.schema.string({
    meta: {
      description: 'Field containing indexed geo-point values.'
    }
  }),
  groupByTimeseries: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: `When true, results are grouped by time_series aggregation, creating a line feature for each time_series group.`
    }
  })),
  lineSimplificationSize: _configSchema.schema.maybe(_configSchema.schema.number({
    max: 10000,
    min: 1,
    defaultValue: 500,
    meta: {
      description: `The maximum number of points for each line. Line is simplifed when threshold is exceeded. Use smaller values for better performance.`
    }
  })),
  splitField: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Field used to group results by term aggregation, creating a line feature for each term. Required when groupByTimeseries is false. Ignored when groupByTimeseries is true.`
    }
  })),
  sortField: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Numeric field used as the sort key for ordering the points. Required when groupByTimeseries is false. Ignored when groupByTimeseries is true.`
    }
  })),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ES_GEO_LINE)
}, {
  meta: {
    description: 'Vector feature source returning lines from Elasticsearch geo_line aggregation. One feature is returned per group.'
  },
  unknowns: 'forbid'
});
const ESPewPewSourceSchema = exports.ESPewPewSourceSchema = BaseESAggSourceSchema.extends({
  destGeoField: _configSchema.schema.string({
    meta: {
      description: `Field containing indexed geo-point values.`
    }
  }),
  sourceGeoField: _configSchema.schema.string({
    meta: {
      description: `Field containing indexed geo-point values.`
    }
  }),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ES_PEW_PEW)
}, {
  meta: {
    description: 'Vector feature source returning lines from Elasticsearch nested geotile_grid aggregation. Results grouped by destintation point, creating one feature per destination point and source geotile_grid bucket.'
  },
  unknowns: 'forbid'
});