"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeProjectRoutingManager = initializeProjectRoutingManager;
var _rxjs = require("rxjs");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Initializes project routing manager for Maps app.
 * Handles subscription to CPS project picker changes and project routing overrides.
 *
 * @param onProjectRoutingChange - Callback invoked when project routing changes
 * @returns Cleanup function to unsubscribe and cleanup resources
 */
function initializeProjectRoutingManager({
  onProjectRoutingChange
}) {
  var _getCps;
  const cpsManager = (_getCps = (0, _kibana_services.getCps)()) === null || _getCps === void 0 ? void 0 : _getCps.cpsManager;
  if (!cpsManager || cpsManager.getProjectPickerAccess() === 'disabled') {
    return;
  }
  const initialProjectRouting = cpsManager.getProjectRouting();
  if (initialProjectRouting) {
    onProjectRoutingChange(initialProjectRouting);
  }
  const cpsProjectRoutingSubscription = cpsManager.getProjectRouting$().pipe((0, _rxjs.distinctUntilChanged)()).subscribe(cpsProjectRouting => {
    onProjectRoutingChange(cpsProjectRouting);
  });
  return () => {
    cpsProjectRoutingSubscription === null || cpsProjectRoutingSubscription === void 0 ? void 0 : cpsProjectRoutingSubscription.unsubscribe();
  };
}