"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBreadcrumbs = getBreadcrumbs;
exports.unsavedChangesWarning = exports.unsavedChangesTitle = void 0;
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../../kibana_services");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unsavedChangesWarning = exports.unsavedChangesWarning = _i18n.i18n.translate('xpack.maps.breadCrumbs.unsavedChangesWarning', {
  defaultMessage: 'Leave Maps with unsaved work?'
});
const unsavedChangesTitle = exports.unsavedChangesTitle = _i18n.i18n.translate('xpack.maps.breadCrumbs.unsavedChangesTitle', {
  defaultMessage: 'Unsaved changes'
});
function getBreadcrumbs({
  pageTitle,
  isByValue,
  getHasUnsavedChanges,
  originatingApp,
  getAppNameFromId,
  history
}) {
  const breadcrumbs = [];
  if (originatingApp && getAppNameFromId) {
    breadcrumbs.push({
      onClick: () => {
        (0, _kibana_services.getNavigateToApp)()(originatingApp);
      },
      text: getAppNameFromId(originatingApp)
    });
  }
  if (!isByValue) {
    breadcrumbs.push({
      text: _constants.APP_NAME,
      onClick: async () => {
        if (getHasUnsavedChanges()) {
          const confirmed = await (0, _kibana_services.getCoreOverlays)().openConfirm(unsavedChangesWarning, {
            title: unsavedChangesTitle,
            'data-test-subj': 'appLeaveConfirmModal'
          });
          if (confirmed) {
            history.push('/');
          }
        } else {
          history.push('/');
        }
      }
    });
  }
  breadcrumbs.push({
    text: pageTitle
  });
  return breadcrumbs;
}