"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocation = getLocation;
var _create_region_map_layer_descriptor = require("../../classes/layers/create_region_map_layer_descriptor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLocation(params, deps) {
  const {
    label,
    emsLayerId,
    leftFieldName,
    termsFieldName,
    termsSize,
    colorSchema,
    indexPatternId,
    metricAgg,
    metricFieldName,
    filters,
    query,
    timeRange,
    hash = true
  } = params;
  const initialLayers = [];
  const regionMapLayerDescriptor = (0, _create_region_map_layer_descriptor.createRegionMapLayerDescriptor)({
    label,
    emsLayerId,
    leftFieldName,
    termsFieldName,
    termsSize,
    colorSchema,
    indexPatternId,
    metricAgg,
    metricFieldName
  });
  if (regionMapLayerDescriptor) {
    initialLayers.push(regionMapLayerDescriptor);
  }
  return await deps.locator.getLocation({
    initialLayers,
    filters,
    query,
    timeRange,
    hash
  });
}