"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESAggTooltipProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _es_tooltip_property = require("./es_tooltip_property");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ESAggTooltipProperty extends _es_tooltip_property.ESTooltipProperty {
  constructor(tooltipProperty, indexPattern, field, aggType, applyGlobalQuery) {
    super(tooltipProperty, indexPattern, field, applyGlobalQuery);
    (0, _defineProperty2.default)(this, "_aggType", void 0);
    (0, _defineProperty2.default)(this, "_aggField", void 0);
    this._aggType = aggType;
    this._aggField = field;
  }
  getHtmlDisplayValue() {
    const rawValue = this.getRawValue();
    return typeof rawValue !== 'undefined' && this._aggField.isCount() ? parseInt(rawValue, 10).toLocaleString() : super.getHtmlDisplayValue();
  }
  isFilterable() {
    return this._aggType === _constants.AGG_TYPE.TERMS ? super.isFilterable() : false;
  }
}
exports.ESAggTooltipProperty = ESAggTooltipProperty;