"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelZoomRangeProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _style_property = require("./style_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LabelZoomRangeProperty extends _style_property.AbstractStyleProperty {
  constructor(options, styleName, layerMinZoom, layerMaxZoom) {
    super(options, styleName);
    (0, _defineProperty2.default)(this, "_layerMinZoom", void 0);
    (0, _defineProperty2.default)(this, "_layerMaxZoom", void 0);
    this._layerMinZoom = layerMinZoom;
    this._layerMaxZoom = layerMaxZoom;
  }
  syncLabelZoomRange(mbLayerId, mbMap) {
    const {
      maxZoom,
      minZoom
    } = this.getLabelZoomRange();
    mbMap.setLayerZoomRange(mbLayerId, minZoom, maxZoom);
  }
  getLayerZoomRange() {
    return {
      maxZoom: this._layerMaxZoom,
      minZoom: this._layerMinZoom
    };
  }
  getLabelZoomRange() {
    const {
      useLayerZoomRange,
      maxZoom,
      minZoom
    } = this.getOptions();
    return useLayerZoomRange ? this.getLayerZoomRange() : {
      maxZoom: Math.min(this._layerMaxZoom, maxZoom),
      minZoom: Math.max(this._layerMinZoom, minZoom)
    };
  }
}
exports.LabelZoomRangeProperty = LabelZoomRangeProperty;