"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformOut = getTransformOut;
var _get_transform_in = require("./get_transform_in");
var _constants = require("../../constants");
var _transform_map_attributes_out = require("../../content_management/transform_map_attributes_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransformOut(transformEnhancementsOut) {
  function transformOut(state, panelReferences, containerReferences) {
    const enhancementsState = state.enhancements ? transformEnhancementsOut(state.enhancements, panelReferences !== null && panelReferences !== void 0 ? panelReferences : []) : undefined;

    // by ref
    const savedObjectRef = (panelReferences !== null && panelReferences !== void 0 ? panelReferences : []).find(ref => _constants.MAP_SAVED_OBJECT_TYPE === ref.type && ref.name === _get_transform_in.MAP_SAVED_OBJECT_REF_NAME);
    if (savedObjectRef) {
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        savedObjectId: savedObjectRef.id
      };
    }

    // by value
    if (state.attributes) {
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        attributes: (0, _transform_map_attributes_out.transformMapAttributesOut)(state.attributes, targetName => {
          const panelRef = (panelReferences !== null && panelReferences !== void 0 ? panelReferences : []).find(({
            name
          }) => name === targetName);
          if (panelRef) return panelRef;
          return (containerReferences !== null && containerReferences !== void 0 ? containerReferences : []).find(({
            name
          }) => name === targetName);
        })
      };
    }
    return {
      ...state,
      ...(enhancementsState ? {
        enhancements: enhancementsState
      } : {})
    };
  }
  return transformOut;
}