"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActiveMaintenanceWindowsRoute = void 0;
var _verify_access_and_context = require("../../../../lib/verify_access_and_context");
var _common = require("../../../../../../common");
var _transforms = require("../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActiveMaintenanceWindowsRoute = (router, licenseState) => {
  router.get({
    path: _common.INTERNAL_ALERTING_API_GET_ACTIVE_MAINTENANCE_WINDOWS_PATH,
    validate: {},
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    // We do not want to throw for this route because other solutions
    // will be using it to determine whether or not they should
    // display a callout in their rules list.
    try {
      licenseState.ensureLicenseForMaintenanceWindow();
    } catch (e) {
      return res.ok({
        body: []
      });
    }
    const maintenanceWindowClient = (await context.maintenanceWindow).getMaintenanceWindowClient();
    const maintenanceWindows = await maintenanceWindowClient.getActiveMaintenanceWindows();
    const response = {
      body: maintenanceWindows.map(maintenanceWindow => (0, _transforms.transformInternalMaintenanceWindowToExternalV1)(maintenanceWindow))
    };
    return res.ok(response);
  })));
};
exports.getActiveMaintenanceWindowsRoute = getActiveMaintenanceWindowsRoute;