"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaintenanceWindowRoute = void 0;
var _verify_access_and_context = require("../../../../lib/verify_access_and_context");
var _common = require("../../../../../../common");
var _get = require("../../../../schemas/maintenance_window/internal/request/get");
var _transforms = require("../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMaintenanceWindowRoute = (router, licenseState) => {
  router.get({
    path: `${_common.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/{id}`,
    validate: {
      params: _get.getParamsSchemaV1
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const maintenanceWindowClient = (await context.maintenanceWindow).getMaintenanceWindowClient();
    const params = req.params;
    const maintenanceWindow = await maintenanceWindowClient.get({
      id: params.id
    });
    const response = {
      body: (0, _transforms.transformInternalMaintenanceWindowToExternalV1)(maintenanceWindow)
    };
    return res.ok(response);
  })));
};
exports.getMaintenanceWindowRoute = getMaintenanceWindowRoute;