"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LlmTasksPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _productDocCommon = require("@kbn/product-doc-common");
var _tasks = require("./tasks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LlmTasksPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, setupDependencies) {
    return {};
  }
  start(core, startDependencies) {
    const {
      inference,
      productDocBase
    } = startDependencies;
    return {
      retrieveDocumentationAvailable: async options => {
        var _options$resourceType;
        const resourceType = (_options$resourceType = options.resourceType) !== null && _options$resourceType !== void 0 ? _options$resourceType : _productDocCommon.ResourceTypes.productDoc;
        if (resourceType === _productDocCommon.ResourceTypes.securityLabs) {
          const status = await startDependencies.productDocBase.management.getSecurityLabsStatus({
            inferenceId: options.inferenceId
          });
          return status.status === 'installed';
        }
        const docBaseStatus = await startDependencies.productDocBase.management.getStatus({
          inferenceId: options.inferenceId
        });
        return docBaseStatus.status === 'installed';
      },
      retrieveDocumentation: options => {
        return (0, _tasks.retrieveDocumentation)({
          outputAPI: inference.getClient({
            request: options.request
          }).output,
          searchDocAPI: productDocBase.search,
          logger: this.logger.get('tasks.retrieve-documentation')
        })(options);
      }
    };
  }
}
exports.LlmTasksPlugin = LlmTasksPlugin;