"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExceptionListItemRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("./utils");
var _validate_comments_to_update = require("./utils/validate_comments_to_update");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateExceptionListItemRoute = router => {
  router.versioned.put({
    access: 'public',
    path: _securitysolutionListConstants.EXCEPTION_LIST_ITEM_URL,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_ALL]
      }
    }
  }).addVersion({
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_api.UpdateExceptionListItemRequestBody)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const validationErrors = (0, _validate_comments_to_update.validateCommentsToUpdate)(request.body.comments);
    if (validationErrors.length) {
      return siemResponse.error({
        body: validationErrors,
        statusCode: 400
      });
    }
    try {
      const {
        description,
        id,
        name,
        meta,
        type,
        _version,
        comments,
        entries,
        item_id: itemId,
        namespace_type: namespaceType,
        os_types: osTypes,
        tags,
        expire_time: expireTime
      } = request.body;
      if (id == null && itemId == null) {
        return siemResponse.error({
          body: 'either id or item_id need to be defined',
          statusCode: 404
        });
      }
      const exceptionLists = await (0, _.getExceptionListClient)(context);
      const exceptionListItem = await exceptionLists.updateOverwriteExceptionListItem({
        _version,
        comments,
        description,
        entries,
        expireTime,
        id,
        itemId,
        meta,
        name,
        namespaceType,
        osTypes,
        tags,
        type
      });
      if (exceptionListItem == null) {
        return siemResponse.error({
          body: id != null ? `exception list item id: "${id}" does not exist` : `exception list item item_id: "${itemId}" does not exist`,
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.UpdateExceptionListItemResponse.parse(exceptionListItem)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.updateExceptionListItemRoute = updateExceptionListItemRoute;