"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readListIndexRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _api = require("@kbn/securitysolution-lists-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("../utils");
var _2 = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readListIndexRoute = router => {
  router.versioned.get({
    access: 'public',
    path: _securitysolutionListConstants.LIST_INDEX,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_READ]
      }
    }
  }).addVersion({
    validate: false,
    version: '2023-10-31'
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const lists = await (0, _2.getListClient)(context);
      const listDataStreamExists = await lists.getListDataStreamExists();
      const listItemDataStreamExists = await lists.getListItemDataStreamExists();
      if (listDataStreamExists && listItemDataStreamExists) {
        return response.ok({
          body: _api.ReadListIndexResponse.parse({
            list_index: listDataStreamExists,
            list_item_index: listItemDataStreamExists
          })
        });
      } else if (!listDataStreamExists && listItemDataStreamExists) {
        return siemResponse.error({
          body: `data stream ${lists.getListName()} does not exist`,
          statusCode: 404
        });
      } else if (!listItemDataStreamExists && listDataStreamExists) {
        return siemResponse.error({
          body: `data stream ${lists.getListItemName()} does not exist`,
          statusCode: 404
        });
      } else {
        return siemResponse.error({
          body: `data stream ${lists.getListName()} and data stream ${lists.getListItemName()} does not exist`,
          statusCode: 404
        });
      }
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.readListIndexRoute = readListIndexRoute;