"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilPluginStartServicesReady = exports.uiActions = exports.trackUiMetric = exports.setKibanaServices = exports.presentationUtil = exports.embeddableService = exports.dashboardServices = exports.coreServices = exports.contentManagement = void 0;
var _rxjs = require("rxjs");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let coreServices = exports.coreServices = void 0;
let dashboardServices = exports.dashboardServices = void 0;
let embeddableService = exports.embeddableService = void 0;
let presentationUtil = exports.presentationUtil = void 0;
let contentManagement = exports.contentManagement = void 0;
let uiActions = exports.uiActions = void 0;
let trackUiMetric = exports.trackUiMetric = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = (kibanaCore, deps) => {
  exports.coreServices = coreServices = kibanaCore;
  exports.dashboardServices = dashboardServices = deps.dashboard;
  exports.embeddableService = embeddableService = deps.embeddable;
  exports.presentationUtil = presentationUtil = deps.presentationUtil;
  exports.contentManagement = contentManagement = deps.contentManagement;
  exports.uiActions = uiActions = deps.uiActions;
  if (deps.usageCollection) exports.trackUiMetric = trackUiMetric = deps.usageCollection.reportUiCounter.bind(deps.usageCollection, _common.CONTENT_ID);
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;