"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _transforms = require("../../../common/content_management/v1/transforms");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: _schema.lensCMGetResultSchema,
        up: result => {
          return {
            ...result,
            item: (0, _transforms.transformToV1LensSavedObject)(result.item)
          };
        }
      }
    }
  },
  create: {
    in: {
      data: {
        schema: _schema.lensItemAttributesSchema,
        up: attributes => {
          return (0, _transforms.transformToV1LensItemAttributes)(attributes);
        }
      },
      options: {
        schema: _schema.lensCMCreateOptionsSchema
      }
    },
    out: {
      result: {
        schema: _schema.lensCMCreateResultSchema
      }
    }
  },
  update: {
    in: {
      data: {
        schema: _schema.lensItemAttributesSchema,
        up: attributes => {
          return (0, _transforms.transformToV1LensItemAttributes)(attributes);
        }
      },
      options: {
        schema: _schema.lensCMUpdateOptionsSchema
      }
    },
    out: {
      result: {
        schema: _schema.lensCMUpdateResultSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: _schema.lensCMSearchOptionsSchema
      }
    },
    out: {
      result: {
        schema: _schema.lensCMSearchResultSchema,
        up: item => {
          // apply v1 transform per item, items may have different versions
          return (0, _transforms.transformToV1LensSavedObject)(item);
        }
      }
    }
  }
};