"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensRequestConfig = getLensRequestConfig;
exports.getLensResponseItem = getLensResponseItem;
var _lensCommon = require("@kbn/lens-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts Lens request data to Lens Config
 */
function getLensRequestConfig(builder, request) {
  var _attributes$title, _attributes$descripti;
  const chartType = builder.getType(request);
  const useApiFormat = builder.isSupported(chartType);
  if (useApiFormat) {
    const config = request;
    const attributes = builder.fromAPIFormat(config);
    return {
      ...attributes
    };
  }
  if (!('state' in request)) {
    // This should never happen, only to typeguard until fully supported
    throw new Error('Failure to transform API Format');
  }
  const {
    visualizationType,
    ...attributes
  } = request;
  if (!visualizationType) {
    throw new Error('Missing visualizationType');
  }
  return {
    ...attributes,
    // TODO: fix these type issues
    visualizationType,
    title: (_attributes$title = attributes.title) !== null && _attributes$title !== void 0 ? _attributes$title : '',
    description: (_attributes$descripti = attributes.description) !== null && _attributes$descripti !== void 0 ? _attributes$descripti : undefined
  };
}

/**
 * Used to extend the meta of the response item. Needed in Lens GET request.
 */

/**
 * Converts Lens Saved Object to Lens Response Item
 */
function getLensResponseItem(builder, item, extraMeta = {}) {
  const {
    id,
    references,
    attributes
  } = item;
  const meta = getLensResponseItemMeta(item, extraMeta);
  const useApiFormat = builder.isSupported(attributes.visualizationType);
  if (useApiFormat) {
    var _attributes$visualiza;
    const data = builder.toAPIFormat({
      references,
      ...attributes,
      // TODO: fix these type issues
      state: attributes.state,
      visualizationType: (_attributes$visualiza = attributes.visualizationType) !== null && _attributes$visualiza !== void 0 ? _attributes$visualiza : _lensCommon.LENS_UNKNOWN_VIS
    });
    return {
      id,
      data,
      meta
    };
  }
  return {
    id,
    data: {
      references,
      ...attributes
    },
    meta
  };
}

/**
 * Converts Lens Saved Object to Lens Response Item
 */
function getLensResponseItemMeta({
  type,
  createdAt,
  updatedAt,
  createdBy,
  updatedBy,
  managed,
  originId
}, extraMeta = {}) {
  return {
    type,
    createdAt,
    updatedAt,
    createdBy,
    updatedBy,
    managed,
    originId,
    ...extraMeta
  };
}