"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.xyLegendValues = exports.legendOptions = exports.defaultLegendTitle = exports.XyLegendSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _to_expression = require("../to_expression");
var _datasource_default_values = require("../../../shared_components/datasource_default_values");
var _visualization_helpers = require("../visualization_helpers");
var _shared_components = require("../../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/toolbar/legend_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultLegendTitle = exports.defaultLegendTitle = _i18n.i18n.translate('xpack.lens.xyChart.legendTitle', {
  defaultMessage: 'Legend'
});
const XyLegendSettings = ({
  state,
  setState,
  frame
}) => {
  var _frame$activeData$dat, _frame$activeData, _frame$activeData$dat2, _frame$activeData$dat3, _state$legend$shouldT;
  const legendMode = state !== null && state !== void 0 && state.legend.isVisible && !(state !== null && state !== void 0 && state.legend.showSingleSeries) ? 'auto' : !(state !== null && state !== void 0 && state.legend.isVisible) ? 'hide' : 'show';
  const dataLayers = (0, _visualization_helpers.getDataLayers)(state === null || state === void 0 ? void 0 : state.layers);
  const defaultParamsFromDatasources = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  const nonOrdinalXAxis = dataLayers.every(layer => {
    var _frame$datasourceLaye, _frame$datasourceLaye2;
    return layer.xAccessor && (0, _to_expression.getScaleType)((_frame$datasourceLaye = (_frame$datasourceLaye2 = frame.datasourceLayers[layer.layerId]) === null || _frame$datasourceLaye2 === void 0 ? void 0 : _frame$datasourceLaye2.getOperationForColumnId(layer.xAccessor)) !== null && _frame$datasourceLaye !== void 0 ? _frame$datasourceLaye : null, _charts.ScaleType.Linear) !== 'ordinal';
  });
  const legendSize = state.legend.legendSize;
  return /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettings, {
    legendOptions: legendOptions,
    mode: legendMode,
    location: state !== null && state !== void 0 && state.legend.isInside ? 'inside' : 'outside',
    onLocationChange: location => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          isInside: location === 'inside'
        }
      });
    },
    titlePlaceholder: (_frame$activeData$dat = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$dat2 = _frame$activeData[dataLayers[0].layerId]) === null || _frame$activeData$dat2 === void 0 ? void 0 : (_frame$activeData$dat3 = _frame$activeData$dat2.columns.find(col => col.id === dataLayers[0].splitAccessor)) === null || _frame$activeData$dat3 === void 0 ? void 0 : _frame$activeData$dat3.name) !== null && _frame$activeData$dat !== void 0 ? _frame$activeData$dat : defaultLegendTitle,
    legendTitle: state === null || state === void 0 ? void 0 : state.legend.title,
    onLegendTitleChange: ({
      title,
      visible
    }) => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          title,
          isTitleVisible: visible
        }
      });
    },
    isTitleVisible: state === null || state === void 0 ? void 0 : state.legend.isTitleVisible,
    onDisplayChange: optionId => {
      const newMode = legendOptions.find(({
        id
      }) => id === optionId).value;
      setState({
        ...state,
        legend: {
          ...state.legend,
          isVisible: newMode !== 'hide',
          showSingleSeries: newMode === 'show'
        }
      });
    },
    position: state === null || state === void 0 ? void 0 : state.legend.position,
    horizontalAlignment: state === null || state === void 0 ? void 0 : state.legend.horizontalAlignment,
    verticalAlignment: state === null || state === void 0 ? void 0 : state.legend.verticalAlignment,
    floatingColumns: state === null || state === void 0 ? void 0 : state.legend.floatingColumns,
    onFloatingColumnsChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          floatingColumns: val
        }
      });
    },
    maxLines: state === null || state === void 0 ? void 0 : state.legend.maxLines,
    onMaxLinesChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          maxLines: val
        }
      });
    },
    shouldTruncate: (_state$legend$shouldT = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT !== void 0 ? _state$legend$shouldT : defaultParamsFromDatasources,
    onTruncateLegendChange: () => {
      var _state$legend$shouldT2;
      const current = (_state$legend$shouldT2 = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT2 !== void 0 ? _state$legend$shouldT2 : defaultParamsFromDatasources;
      setState({
        ...state,
        legend: {
          ...state.legend,
          shouldTruncate: !current
        }
      });
    },
    onPositionChange: id => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          position: id
        }
      });
    },
    onAlignmentChange: value => {
      const [vertical, horizontal] = value.split('_');
      const verticalAlignment = vertical;
      const horizontalAlignment = horizontal;
      setState({
        ...state,
        legend: {
          ...state.legend,
          verticalAlignment,
          horizontalAlignment
        }
      });
    },
    allowedLegendStats: nonOrdinalXAxis ? xyLegendValues : undefined,
    legendStats: state === null || state === void 0 ? void 0 : state.legend.legendStats,
    onLegendStatsChange: (legendStats, hasConvertedToTable) => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendStats,
          isVisible: true,
          showSingleSeries: true,
          ...(hasConvertedToTable ? {
            legendSize: _chartExpressionsCommon.LegendSize.AUTO
          } : {})
        }
      });
    },
    legendSize: legendSize,
    onLegendSizeChange: newLegendSize => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendSize: newLegendSize
        }
      });
    },
    showAutoLegendSizeOption: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
exports.XyLegendSettings = XyLegendSettings;
const legendOptions = exports.legendOptions = [{
  id: `xy_legend_auto`,
  value: 'auto',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendVisibility.auto', {
    defaultMessage: 'Auto'
  })
}, {
  id: `xy_legend_show`,
  value: 'show',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: `xy_legend_hide`,
  value: 'hide',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const xyLegendValues = exports.xyLegendValues = [{
  value: _charts.LegendValue.Average,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.average', {
    defaultMessage: 'Average'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.averageDesc', {
    defaultMessage: 'Average of all values in the series.'
  })
}, {
  value: _charts.LegendValue.Median,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.median', {
    defaultMessage: 'Median'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.medianDesc', {
    defaultMessage: 'Median value in the series.'
  })
}, {
  value: _charts.LegendValue.Min,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.min', {
    defaultMessage: 'Minimum'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.minDesc', {
    defaultMessage: 'Minimum value in the series.'
  })
}, {
  value: _charts.LegendValue.Max,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.max', {
    defaultMessage: 'Maximum'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.maxDesc', {
    defaultMessage: 'Maximum value in the series.'
  })
}, {
  value: _charts.LegendValue.Range,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.range', {
    defaultMessage: 'Range'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.rangeDesc', {
    defaultMessage: 'Difference between the min and the max in the series.'
  })
}, {
  value: _charts.LegendValue.LastValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastValue', {
    defaultMessage: 'Last value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastValueDesc', {
    defaultMessage: 'Last value in the series.'
  })
}, {
  value: _charts.LegendValue.LastNonNullValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastNonNullValue', {
    defaultMessage: 'Last non-null value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastNonNullValueDesc', {
    defaultMessage: 'Last non-null value in the series.'
  })
}, {
  value: _charts.LegendValue.FirstValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstValue', {
    defaultMessage: 'First value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstValueDesc', {
    defaultMessage: 'First value in the series.'
  })
}, {
  value: _charts.LegendValue.FirstNonNullValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstNonNullValue', {
    defaultMessage: 'First non-null value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstNonNullValueDesc', {
    defaultMessage: 'First non-null value in the series.'
  })
}, {
  value: _charts.LegendValue.Difference,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.diff', {
    defaultMessage: 'Difference'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.diffDesc', {
    defaultMessage: 'Difference between first and last value in the series.'
  })
}, {
  value: _charts.LegendValue.DifferencePercent,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.diffPercent', {
    defaultMessage: 'Difference %'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.diffPercentDesc', {
    defaultMessage: 'Difference in percent between first and last value in the series.'
  })
}, {
  value: _charts.LegendValue.Total,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.total', {
    defaultMessage: 'Sum'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.totalDesc', {
    defaultMessage: 'The sum of all values in the series.'
  })
}, {
  value: _charts.LegendValue.Count,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.count', {
    defaultMessage: 'Count'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.countDesc', {
    defaultMessage: 'Count of all the values in the series.'
  })
}, {
  value: _charts.LegendValue.DistinctCount,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.distinctCount', {
    defaultMessage: 'Distinct count'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.distinctCountDesc', {
    defaultMessage: 'Count of distinct values in the series.'
  })
}, {
  value: _charts.LegendValue.Variance,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.variance', {
    defaultMessage: 'Variance'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.varianceDesc', {
    defaultMessage: 'Variance of all the values in the series.'
  })
}, {
  value: _charts.LegendValue.StdDeviation,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.stdDev', {
    defaultMessage: 'Std deviation'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.stdDevDesc', {
    defaultMessage: 'Standard deviation of all the values in the series.'
  })
},
// Moved to the bottom to limit its usage. It could cause some UX issues due to the dynamic nature
// of the data displayed
{
  value: _charts.LegendValue.CurrentAndLastValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.currentValue', {
    defaultMessage: 'Current or last value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.currentValueDesc', {
    defaultMessage: 'Value of the bucket being hovered or the last bucket value when not hovering.'
  })
}];