"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToRawColorMappingsFn = void 0;
var _raw_color_mappings = require("../../../../runtime_state/converters/raw_color_mappings");
var _converter = require("../../../../runtime_state/converters/raw_color_mappings/converter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Old color mapping state meant for type safety during runtime migrations of old configurations
 *
 * @deprecated
 */

const convertToRawColorMappingsFn = datasourceStates => {
  const getColumnMeta = (0, _raw_color_mappings.getColumnMetaFn)(datasourceStates);
  return state => {
    const hasDeprecatedColorMapping = state.colorMapping ? (0, _converter.isDeprecatedColorMapping)(state.colorMapping) : false;
    if (!hasDeprecatedColorMapping) return state;
    const columnMeta = state.tagAccessor ? getColumnMeta === null || getColumnMeta === void 0 ? void 0 : getColumnMeta(state.layerId, state.tagAccessor) : null;
    return {
      ...state,
      colorMapping: state.colorMapping && (0, _raw_color_mappings.convertToRawColorMappings)(state.colorMapping, columnMeta)
    };
  };
};
exports.convertToRawColorMappingsFn = convertToRawColorMappingsFn;